﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace TPClib.ROI
{
    /// <summary>
    /// Class for VinciROIFile testing
    /// </summary>
    [TestFixture]
    public class NUnitTestBench_VinciROIFile
    {
        private static String Ppath = "P:\\Data\\ROI\\Vinci\\";

        /// <summary>
        /// Tests reading and writing of Vincifiles
        /// </summary>
        [Test]
        public void Test1_0_ReadWriteFile()
        {
            VinciROIFile file = new VinciROIFile();
            //ROIFile file = new ROIFile();

            file.SetImageInformation(128, 128, 2.40717d, 2.40717d);

            //file.ReadFile(Ppath + "truepxl.vpx");
            //file.ReadFile(Ppath + "Trilinear_Nurkatkin_nozoom.vpx");
            //file.ReadFile(Ppath + "Trilinear_Nurkatkin_zoom.vpx");
            //file.ReadFile(Ppath + "Trilinear_Nurkatkin_smallzoom.vpx");
            //file.ReadFile(Ppath + "TruePxl_Nurkatkin_nozoom.vpx");
            //file.ReadFile(Ppath + "TruePxl_Nurkatkin_withzoom.vpx");
            file.ReadFile(Ppath + "Rotate.vpx");
            //file.ReadFile(Ppath + "trilinear.vpx");

            file.VOIs[0].Fill(128,128,1);
            Console.WriteLine ( file.VOIs[0].GetMatrix().GetRoiMatrix(0).ToString() );

            /*Image.Ecat7File file = new TPClib.Image.Ecat7File("P:\\Data\\ROI\\Imadeus\\Image.v");
            file.ReadFile();

            for (int y = 0; y < file.image.height; y++)
            {
                for (int x = 0; x < file.image.width; x++)
                {
                    file.image[x, y, 0] = 0;
                }
            }
            for (int y = 10; y < 30; y++)
            {
                for (int x = 20; x < 45; x++)
                {
                    file.image[x, y, 0] = 1;
                }
            }

            file.filename = "P:\\Data\\ROI\\Imadeus\\mask.v";
            file.WriteFile();*/
        }
    }
}
