﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;
using TPClib.Image;

namespace TPClib.ROI
{
    /// <summary>
    /// Calculates means of pixel values
    /// </summary>
    public class ROICalculator_Mean : ROICalculator
    {
        private double[] res;
        private int num;

        /// <summary>
        /// Constructs calculator object with length of 1. All other frames are ignored
        /// </summary>
        public ROICalculator_Mean()
        {
            SetLength(1);
        }
        /// <summary>
        /// Constructor that defines number of ROIs.
        /// </summary>
        /// <param name="length">number of ROIs</param>
        public ROICalculator_Mean(int length)
        {
            SetLength(length);
        }
        /// <summary>
        /// Adds other values to all values in ROI. 
        /// </summary>
        /// <param name="value">added values</param>
        public override void AddValue(float[] value)
        {
            for (int i = 0; i < Length; i++)
            {
                res[i] += value[i];
            }
            num++;
        }
        /// <summary>
        /// Returns mean values of all ROIs
        /// </summary>
        /// <returns></returns>
        public override Double[] GetResult()
        {
            double[] result = new double[Length];
            for (int i = 0; i < Length; i++)
            {
                result[i] = res[i] / (double)num;
            }
            return result;
        }
        /// <summary>
        /// Sets number of related ROIs
        /// </summary>
        /// <param name="length">number of ROIs in calculations</param>
        public override void SetLength(int length)
        {
            Length = length;
            res = new double[Length];
            num = 0;
        }
    }
}