﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;

namespace TPClib.ROI
{
    /// <summary>
    /// ROIPoint which can contain also a pixel value
    /// </summary>
    public class ROIValuePoint : Point
    {
        /// <summary>
        /// Image intensity value at point location
        /// </summary>
        public Double Value;
        /// <summary>
        /// Frame number
        /// </summary>
        public Double frame;
        /// <summary>
        /// Constructor with location parameters.
        /// </summary>
        /// <param name="xx">x-coordinate</param>
        /// <param name="yy">y-coordinate</param>
        /// <param name="zz">z-coordinate</param>
        /// <param name="Frame">frame number</param>
        public ROIValuePoint(int xx, int yy, int zz, int Frame)
        {
            x = xx;
            y = yy;
            z = zz;
            frame = Frame;
            Value = 0.0d;
        }
        /// <summary>
        /// Constructor with location parameters as real numbers
        /// </summary>
        /// <param name="xx">x-coordinate</param>
        /// <param name="yy">y-coordinate</param>
        /// <param name="zz">z-coordinate</param>
        /// <param name="Frame">frame number</param>
        public ROIValuePoint(Double xx, Double yy, Double zz, Double Frame)
        {
            x = xx;
            y = yy;
            z = zz;
            frame = Frame;
            Value = 0.0d;
        }
        /// <summary>
        /// Constructor with location parameters as real numbers
        /// </summary>
        /// <param name="xx">x-coordinate</param>
        /// <param name="yy">y-coordinate</param>
        /// <param name="zz">z-coordinate</param>
        /// <param name="Frame">frame number</param>
        /// <param name="val">intensity value at location</param>
        public ROIValuePoint(Double xx, Double yy, Double zz, Double Frame, Double val)
        {
            x = xx;
            y = yy;
            z = zz;
            frame = Frame;
            Value = val;
        }
        /// <summary>
        /// Constructor with location parameters.
        /// </summary>
        /// <param name="xx">x-coordinate</param>
        /// <param name="yy">y-coordinate</param>
        /// <param name="zz">z-coordinate</param>
        /// <param name="Frame">frame number</param>
        /// <param name="val">intensity value at location</param>
        public ROIValuePoint(int xx, int yy, int zz, int Frame, Double val)
        {
            x = xx;
            y = yy;
            z = zz;
            frame = Frame;
            Value = val;
        }
        /// <summary>
        /// Returns string representation of this object.
        /// </summary>
        /// <returns>information about object as string</returns>
        public override string ToString()
        {
            return "[" + x.ToString("f2") + "  " + y.ToString("f2") + "  " + z.ToString("f2") + "  " + frame.ToString("f2") + "] = " + Value.ToString("f3");
        }
    }
}