﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;

namespace TPClib.ROI
{
    /// <summary>
    /// This class hadles transaxial slices. The depeth and the dimensions of the destination matrix
    /// must be given. Class returns x,y and z values in 3D space when the slice's 2D x and y
    /// coordinates are given.
    /// </summary>
    public class Slice_Sagittal : Slice
    {
        /// <summary>
        /// Construrcts a transaxial position class
        /// </summary>
        /// <param name="depeth">Depeth of the slice</param>
        /// <param name="matWidth">Width of the matrix where the slice is taken from</param>
        /// <param name="matHeight">Height of the matrix where the slice is taken from</param>
        /// <param name="matDepeth">Depeth of the matrix where the slice is taken from</param>
        public Slice_Sagittal(int depeth, int matWidth, int matHeight, int matDepeth)
        {
            init(matWidth, matHeight, matDepeth);

            width = matHeight;
            height = matDepeth;
            maxDepeth = matWidth;
            origox = 0; origoy = 0;
            x = depeth;
            y = 0;
            z = 0;

            // normal vector
            normalx = 1;
            normaly = 0;
            normalz = 0;
        }

        /// <summary>
        /// Sets the 2d depeth-value of slice
        /// </summary>
        public override int Depeth2D
        {
            get { return x; }
            set { x = value; }
        }
        /// <summary>
        /// Sets the 2d x-value of slice
        /// </summary>
        public override int X2D
        {
            get { return y; }
            set { y = value; }
        }
        /// <summary>
        /// Sets the 2d y-value of slice
        /// </summary>
        public override int Y2D
        {
            get { return z; }
            set { z = value; }
        }

        /// <summary>
        /// Checks if the 3D dimensions match the dimensions of the slice
        /// </summary>
        public override bool CheckDimensions(int mat_width, int mat_height, int mat_depeth)
        {
            if (this.width != mat_height) return false;
            if (this.height != mat_depeth) return false;
            return true;
        }

    }
}
