﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using TPClib;
using TPClib.Image;

namespace TPCConsoleApplication
{
    /// <summary>
    /// Console program using TPClib library.
    /// </summary>
    class Program: ConsoleProgram
    {
        /// <summary>
        /// File that is opened.
        /// </summary>
        static string filename = "";
        
        
        /// <summary>
        /// Main program.
        /// </summary>
        /// <param name="args">arguments passed from command line</param>
        public static void Main(string[] args)
        {
            
            //example, set program attributes
            programname = "no program name";
            description = "no description";
            usage = "no usage information";



            // Example of adding command prompt parameters

            // Examples of not-flag -type parameters, which are strings and numbers. User can name them freely.
            // User must give them in correct order. The value of first given string- or number-type parameter
            // will be saved to the name, that has been given at first in program with AddParameter-method.

            //example of string-type parameter, that can describe any kind of information, 
            //like file name or person's name (if parameter contains spaces, it must be inside of " ")
            AddParameter("source_file", "example of string-type parameter", true, CategoryType.STRING);
            //example of number-type parameter, that can describe positive or negative decimal numbers
            AddParameter("start_value", "example of number-type parameter", false, CategoryType.NUMBER);
            
            // Examples of flag-type parameters (starting with "-" or "/").
            // Parameter's name must be the same, that has been read from command line after "-" or "/".

            //example of boolean type flag-parameter, whose value is true if it has been given 
            //for example in form "-p"
            AddParameter("p", "example of boolean type flag-parameter", true, CategoryType.PARAM_BOOL);
            //example of char type flag-parameter, for example in form "-u=A"
            AddParameter("u", "example of char type flag-parameter", true, CategoryType.PARAM_CHAR);
            //example of number type flag-parameter (separator can be "." or ",", for example in form -k=4.6
            AddParameter("k", "example of number type flag-parameter", true, CategoryType.PARAM_NUMBER);
            //example of string type flag-parameter, for example -f=filename.xyz
            //(if value contains spaces, it must be inside of " " like -f="filename.001 filename.002")
            AddParameter("f", "example of string type flag-parameter", true, CategoryType.PARAM_STRING);


            // Resolve parameters added from command prompt
            ResolveParameters(args);



            // Get parameter values and save them to variables. GetParameter returns an object value,
            // that must be casted to correct type with StringValue, DoubleValue etc. method before saving it.
            double start = 0;
            bool opt_p = false;
            char opt_l = ' ';
            double opt_k = 0;
            string opt_res_file = "param_string not set";

            if (GetParameter("source_file").HasValue) filename = GetParameter("source_file").StringValue;
            if (GetParameter("start_value").HasValue) start = GetParameter("start_value").DoubleValue;
            if (GetParameter("p").HasValue) opt_p = GetParameter("p").BooleanValue;
            if (GetParameter("u").HasValue) opt_l = GetParameter("u").CharValue;
            if (GetParameter("k").HasValue) opt_k = GetParameter("k").DoubleValue;
            if (GetParameter("f").HasValue) opt_res_file = GetParameter("f").StringValue;

            // example code starts here
            Console.WriteLine(filename);
            Console.WriteLine(start);
            Console.WriteLine(opt_p);
            Console.WriteLine(opt_l);
            Console.WriteLine(opt_k);
            Console.WriteLine(opt_res_file);
        }
    }
}
