/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;

namespace openDicom
{
    /// <summary>
    /// Dicom tag data type
    /// </summary>
    public enum VR
    {
        /// <summary>
        /// AE
        /// </summary>
        AE = ('A' << 8) | 'E',
        /// <summary>
        /// AS
        /// </summary>
        AS = ('A' << 8) | 'S',
        /// <summary>
        /// AT
        /// </summary>
        AT = ('A' << 8) | 'T',
        /// <summary>
        /// CS
        /// </summary>
        CS = ('C' << 8) | 'S',
        /// <summary>
        /// DA
        /// </summary>
        DA = ('D' << 8) | 'A',
        /// <summary>
        /// DS
        /// </summary>
        DS = ('D' << 8) | 'S',
        /// <summary>
        /// DT
        /// </summary>
        DT = ('D' << 8) | 'T',
        /// <summary>
        /// FL
        /// </summary>
        FL = ('F' << 8) | 'L',
        /// <summary>
        /// FD
        /// </summary>
        FD = ('F' << 8) | 'D',
        /// <summary>
        /// IS
        /// </summary>
        IS = ('I' << 8) | 'S',
        /// <summary>
        /// LO
        /// </summary>
        LO = ('L' << 8) | 'O',
        /// <summary>
        /// LT
        /// </summary>
        LT = ('L' << 8) | 'T',
        /// <summary>
        /// OB
        /// </summary>
        OB = ('O' << 8) | 'B',
        /// <summary>
        /// OW
        /// </summary>
        OW = ('O' << 8) | 'W',
        /// <summary>
        /// PW
        /// </summary>
        PN = ('P' << 8) | 'N',
        /// <summary>
        /// SH
        /// </summary>
        SH = ('S' << 8) | 'H',
        /// <summary>
        /// SL
        /// </summary>
        SL = ('S' << 8) | 'L',
        /// <summary>
        /// SQ
        /// </summary>
        SQ = ('S' << 8) | 'Q',
        /// <summary>
        /// SS
        /// </summary>
        SS = ('S' << 8) | 'S',
        /// <summary>
        /// ST
        /// </summary>
        ST = ('S' << 8) | 'T',
        /// <summary>
        /// TM
        /// </summary>
        TM = ('T' << 8) | 'M',
        /// <summary>
        /// UT
        /// </summary>
        UI = ('U' << 8) | 'I',
        /// <summary>
        /// UL
        /// </summary>
        UL = ('U' << 8) | 'L',
        /// <summary>
        /// US
        /// </summary>
        US = ('U' << 8) | 'S',
        /// <summary>
        /// UN
        /// </summary>
        UN = ('U' << 8) | 'N',
        /// <summary>
        /// UT
        /// </summary>
        UT = ('U' << 8) | 'T',
        /// <summary>
        /// special tag (choices)
        /// </summary>
        ox = ('o' << 8) | 'x'
    }
}
