function parse_TAG()
    f = fopen('08_06pu_UIDs.txt','r');
    fo = fopen('parsed_UIDs.dic','w');
    lines = {};
    while 1
        tline = fgetl(f);
        if ~ischar(tline)
            break; 
        end
        if length(tline) == 0
            continue; 
        end
        [T, tline] = strtok(tline);
        fprintf('%s = ',T); 
        fprintf(fo,'%s = ',T);  
        parseLine(fo, 'LDAP OID', tline, 'LdapOid');
        parseLine(fo, 'Well-known Print Queue SOP Instance', tline, 'PrintQueueSopInstance');
        parseLine(fo, 'Well-known Printer SOP Instance', tline, 'PrinterSopInstance');
        parseLine(fo, 'Service Class', tline, 'ServiceClass');
        parseLine(fo, 'DICOM UIDs as a Coding Scheme', tline, 'Unknown');
        parseLine(fo, 'Coding Scheme', tline, 'CodingScheme');
        parseLine(fo, 'Application Context Name', tline, 'ApplicationContextName');
        parseLine(fo, 'Well-known SOP Instance', tline, 'SopInstance');
        parseLine(fo, 'Well-known frame of reference', tline, 'FrameOfReference');
        parseLine(fo, 'Transfer Syntax', tline, 'TransferSyntax');
        parseLine(fo, 'Meta SOP Class', tline, 'MetaSopClass');
        parseLine(fo, 'SOP Class', tline, 'SopClass');
    end
    fclose(f);
    fclose(fo);
    
    
function parseLine(f, name, tline, wname);
    si = findstr(tline,name);
    if length(si) > 0
        tline = tline(1:si(end)-1);
        tline = strtrim(tline);
        tline = strrep(tline,'\t',' ');
        while(length(findstr(tline,'  ')) > 0)
            tline = strrep(tline,'  ',' ');
        end
        fprintf('%s, %s\n',tline,wname);
        fprintf(f,'%s, %s\n',tline,wname);
    end
