﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace AssemblyVersionUpdater
{
    /// <summary>
    /// Program for programmatically changing assembly version according to current SVN 
    /// revision number. The change is done into AssemblyInfo.cs file in TPClib project.
    /// </summary>
    class Program
    {
        /// <summary>
        /// Main program
        /// </summary>
        /// <param name="args">ignored</param>
        static void Main(string[] args)
        {
            string assemblyinformationfile = args[0]+"/Properties/AssemblyInfo.cs";
            string[] lines = File.ReadAllLines(assemblyinformationfile);
            string revision = ResolveLastRevision(args[0] + "/.svn/entries");
            for (int i = 0; i < lines.Length; i++) {
                if(lines[i].StartsWith("[assembly: AssemblyVersion(")) {
                    string version = lines[i].Split(new string[]{"[assembly: AssemblyVersion("}, StringSplitOptions.None)[1];
                    version = version.Substring(1);
                    version = version.Remove(version.Length - 3);
                    Console.Write("["+lines[i]+"] -> ");
                    string[] numbers = version.Split('.');
                    version = numbers[0] + "." + numbers[1] + "." + numbers[2] + "." + revision;
                    Console.WriteLine("["+lines[i]+"]");
                    lines[i] = "[assembly: AssemblyVersion(\"" + version + "\")]";
                }
                if (lines[i].StartsWith("[assembly: AssemblyFileVersion("))
                {
                    string version = lines[i].Split(new string[] { "[assembly: AssemblyFileVersion(" }, StringSplitOptions.None)[1];
                    version = version.Substring(1);
                    version = version.Remove(version.Length - 3);
                    Console.Write("[" + lines[i] + "] -> ");
                    string[] numbers = version.Split('.');
                    version = numbers[0] + "." + numbers[1] + "." + numbers[2] + "." + revision;
                    Console.WriteLine("[" + lines[i] + "]");
                    lines[i] = "[assembly: AssemblyFileVersion(\"" + version + "\")]";
                }
            }
            File.WriteAllLines(assemblyinformationfile, lines);
        }
        /// <summary>
        /// Resolves revision number of SVN repository for the latest change
        /// </summary>
        /// <param name="svn_entry_filename"></param>
        /// <returns></returns>
        static string ResolveLastRevision(string svn_entry_filename) {
            string[] lines = File.ReadAllLines(svn_entry_filename);
            return lines[3];
        }
    }
}
