/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;

namespace TPClib.Curve
{
    /// <summary>
    /// FitFile time tacs related dataFunctions
    /// </summary>
    public class FitTime
    {
        /// <summary>
        /// Converts string to TimeUnit format.
        /// </summary>
        /// <param name="u">string to be converted</param>
        /// <returns>the converted unit</returns>
        public static TimeUnit Convert(string u)
        {
            if ("min" == u) return TimeUnit.minute;
            if ("sec" == u) return TimeUnit.second;
            if ("s" == u) return TimeUnit.second;
            if ("h" == u) return TimeUnit.hour;
            if ("usec" == u) return TimeUnit.microsecond;
            if ("msec" == u) return TimeUnit.millisecond;
            if ("nsec" == u) return TimeUnit.nanosecond;
            throw new Exception();
        }

        /// <summary>
        /// Converts TimeUnit to string expression.
        /// </summary>
        /// <param name="u">unit to be converted.</param>
        /// <returns>the converted unit</returns>
        public static string Convert(TimeUnit u)
        {
            if (TimeUnit.minute == u) return "min";
            if (TimeUnit.second == u) return "sec";
            if (TimeUnit.hour == u) return "h";
            if (TimeUnit.microsecond == u) return "usec";
            if (TimeUnit.millisecond == u) return "msec";
            if (TimeUnit.nanosecond == u) return "nsec";

            throw new Exception();
        }
    }
}