/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;
using System.IO;

namespace TPClib.Curve
{
    /// <summary>
    /// Interfile curve file
    /// </summary>
    public class IFCurveFile : CurveFile
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        public IFCurveFile()
        {
            throw new System.NotImplementedException();
        }

        /// <summary>
        /// Read IF file contents and create a Multicurve object, emptying its old contents
        /// </summary>
        public override void ReadFile()
        {
            if (!CheckFormat(filename)) throw new TPCIFFileException("Fileformat not recognized.");

        }

        /// <summary>
        /// Checks file format based on filename extension.
        /// </summary>
        /// <param name="filename">full path to file</param>
        /// <returns>true if file is a IF file</returns>
        /// <exception cref="TPCIFFileException">if there was a read problem</exception>
        public static bool CheckFormat(string filename)
        {
            FileInfo file = new FileInfo(filename);            
            if (String.Compare(file.Extension, "if", true) == 0) //case insensitive comparison
            {
                //try to read file with readFile()
                try
                {
                    IFCurveFile iffile = new IFCurveFile();
                    iffile.filename = filename;
                    iffile.ReadFile();
                    return true;
                } catch(Exception) {
                    return false;
                }          
            }
            else
            {
                return false;
            }
        }
    }
}
