/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

namespace TPClib
{
    /// <summary>
    /// Event handler for I/O progress notifications.
    /// </summary>
    /// <param name="sender">object that sent the event</param>
    /// <param name="e">event arguments</param>
    public delegate void IOProcessEventHandler(object sender, IOProgressEventArgs e);
    /// <summary>
    /// Event arguments for I/O actions
    /// </summary>
    public class IOProgressEventArgs : ProgressEventArgs
    {
        /// <summary>
        /// Creates new I/O event arguments
        /// </summary>
        /// <param name="percent">estimated percent of operation ready 100.0 ready</param>
        /// <param name="method">method where event occurred</param>
        /// <param name="desc">additional description of current process</param>
        public IOProgressEventArgs(float percent, System.Reflection.MethodBase method, string desc)
        {
            this.percent = percent;
            this.method = method;
        }
        /// <summary>
        /// Creates new I/O event arguments
        /// </summary>
        /// <param name="percent">estimated percent of operation ready 100.0 ready</param>
        /// <param name="method">method where event occurred</param>
        public IOProgressEventArgs(float percent, System.Reflection.MethodBase method)
        {
            this.percent = percent;
            this.method = method;
        }
    }
}