/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;
using System.Collections;

namespace TPClib.Image
{
	/// <summary>
	/// NOTE: REPLACEMENT FOR A MISSING CLASS FILE DataMatrix.cs
	/// FUNCTION DECLARATIONS COPIED FROM A COMPILED DLL
	/// </summary>
	public abstract class DataMatrix : IEnumerable
	{
		/// <summary>
		/// Number of data points
		/// </summary>
		public abstract int DataLength { get; }

		/// <summary>
		/// 
		/// </summary>
		/// <param name="p"></param>
		/// <returns></returns>
		public abstract float this[IntPoint p] { set; get; }
		
		/// <summary>
		/// 
		/// </summary>
		/// <param name="p"></param>
		/// <returns></returns>
		public abstract float this[Point p] { set; get; }
		
		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="z"></param>
		/// <param name="t"></param>
		/// <returns></returns>
		public abstract float this[int x, int y, int z, int t] { set; get; }
		
		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="z"></param>
		/// <returns></returns>
		public abstract float this[int x, int y, int z] { set; get; }
		
		/// <summary>
		/// 
		/// </summary>
		/// <param name="location"></param>
		/// <returns></returns>
		public abstract float this[int location] { set; get; }

		#region Abstract methods

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract float[] GetArray();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract IEnumerator GetEnumerator();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract float GetMax();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract float GetMean(IntLimits subregion);

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract float GetMean();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract float GetMin();

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public abstract float[] GetMinMax();

		/// <summary>
		/// 
		/// </summary>
		/// <param name="subregion"></param>
		/// <returns></returns>
		public abstract float[] GetMinMax(IntLimits subregion);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="limits"></param>
		/// <returns></returns>
		public abstract Image GetSubImage(IntLimits limits);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="location"></param>
		/// <returns></returns>
		public abstract float GetValue(int[] location);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="z"></param>
		/// <param name="t"></param>
		/// <returns></returns>
		public abstract float GetValue(int x, int y, int z, int t);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="z"></param>
		/// <returns></returns>
		public abstract float GetValue(int x, int y, int z);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="point"></param>
		/// <returns></returns>
		public abstract float GetValue(IntPoint point);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="index"></param>
		public abstract float GetValue(int index);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		public abstract void Multiply(float value);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="limits"></param>
		/// <param name="image"></param>
		public abstract void SetSubImage(IntLimits limits, ref Image image);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="location"></param>
		public abstract void SetValue(float value, int[] location);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="point"></param>
		/// <param name="value"></param>
		public abstract void SetValue(IntPoint point, float value);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		public abstract void SetValue(int index, float value);

		#endregion
	}
}
