/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;

namespace TPClib.Image
{
	/// <summary>
	/// Image orientation
	/// </summary>
	public class Orientation : IEquatable<Orientation>
	{
		/// <summary>
		/// 
		/// </summary>
		public readonly bool RightToLeft;

		/// <summary>
		/// 
		/// </summary>
		public readonly bool AnteriorToPosterior;

		/// <summary>
		/// 
		/// </summary>
		public readonly bool SuperiorToInferior;

		/// <summary>
		/// 
		/// </summary>
		/// <param name="rightLeft"></param>
		/// <param name="anteriorPosterior"></param>
		/// <param name="superiorInferior"></param>
		public Orientation(bool rightLeft = false, bool anteriorPosterior = false, bool superiorInferior = false)
		{
			RightToLeft = rightLeft;
			AnteriorToPosterior = anteriorPosterior;
			SuperiorToInferior = superiorInferior;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="flipX"></param>
		/// <param name="flipY"></param>
		/// <param name="flipZ"></param>
		/// <returns></returns>
		public Orientation Flip(bool flipX, bool flipY, bool flipZ)
		{
			return new Orientation(this.RightToLeft ^ flipX,
									this.AnteriorToPosterior ^ flipY,
									this.SuperiorToInferior ^ flipZ);
		}

		/// <summary>
		/// RAS (default)
		/// </summary>
		public static readonly Orientation RAS = new Orientation();

		/// <summary>
		/// RAI
		/// </summary>
		public static readonly Orientation RAI = new Orientation(false, false, true);

		/// <summary>
		/// RPS
		/// </summary>
		public static readonly Orientation RPS = new Orientation(false, true, false);

		/// <summary>
		/// RPI
		/// </summary>
		public static readonly Orientation RPI = new Orientation(false, true, true);

		/// <summary>
		/// LAS
		/// </summary>
		public static readonly Orientation LAS = new Orientation(true, false, false);

		/// <summary>
		/// LAI
		/// </summary>
		public static readonly Orientation LAI = new Orientation(true, false, true);

		/// <summary>
		/// LPS
		/// </summary>
		public static readonly Orientation LPS = new Orientation(true, true, false);

		/// <summary>
		/// LPI
		/// </summary>
		public static readonly Orientation LPI = new Orientation(true, true, true);

		/// <summary>
		/// Radiological orientation (LAS)
		/// </summary>
		public static readonly Orientation Radiological = LAS;

		/// <summary>
		/// Neurological orientation (RAI)
		/// </summary>
		public static readonly Orientation Neurological = RAI;

		/// <summary>
		/// HRRT orientation
		/// </summary>
		public static readonly Orientation HRRT = Radiological;

		/// <summary>
		/// Orientation equality.
		/// </summary>
		/// <param name="other">Compared orientation</param>
		/// <returns>True, if orientations are identical</returns>
		public bool Equals(Orientation other)
		{
			return
				(this.RightToLeft == other.RightToLeft) &&
				(this.AnteriorToPosterior == other.AnteriorToPosterior) &&
				(this.SuperiorToInferior == other.SuperiorToInferior);
		}
	}
}
