/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System.IO;

namespace TPClib.Image
{
	/// <summary>
	/// Interface for fileformats capable of reading image data in a stream form.
	/// </summary>
	public interface IStreamReader
	{
		/// <summary>
		/// Get an ImageStream of the entire image.
		/// </summary>
		/// <returns>ImageStream for the image</returns>
		ImageStream GetStream(FileAccess a);
		
		/// <summary>
		/// Get an ImageStream of a sub image.
		/// </summary>
		/// <param name="limits">Sub image limits</param>
		/// <returns>Sub image stream</returns>
		ImageStream GetStream(IntLimits limits, FileAccess a);
	}

	/// <summary>
	/// Interface for fileformats capable of writing image data from a stream.
	/// </summary>
	public interface IStreamWriter
	{
		/// <summary>
		/// Write the contents of a stream to a file.
		/// </summary>
		/// <param name="imgs">ImageStream with image data</param>
		void WriteFile(ImageStream imgs);
	}

	/// <summary>
	/// Combines both IStream reader and IStreamWriter.
	/// </summary>
	public interface IStreamableImage : IStreamReader, IStreamWriter { }
}
