/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;

namespace TPClib.Image.ValueScales
{
    /// <summary>
    /// Interface for all Value Scale converters
    /// </summary>
    /// <typeparam name="T">The source value type</typeparam>
    /// <typeparam name="K">The destination value type</typeparam>
    public interface IConverter<T, K>
        where T : struct, IConvertible, IComparable
        where K : struct, IConvertible, IComparable
    {
        /// <summary>
        /// Converts one value
        /// </summary>
        /// <param name="value">Value that is converted</param>
        /// <returns>The converted value</returns>
        K Convert(T value);

        /// <summary>
        /// Converts array of objects
        /// </summary>
        /// <param name="fromArray">Source array</param>
        /// <param name="fromIndex">Starting index of source Array</param>
        /// <param name="toArray">Destination Array</param>
        /// <param name="toIndex">Starting index of destination Array</param>
        /// <param name="length">Length of conversion</param>
        void Convert(T[] fromArray, int fromIndex, K[] toArray, int toIndex, int length);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="fromArray"></param>
		/// <param name="fromIndex"></param>
		/// <param name="toArray"></param>
		/// <param name="toIndex"></param>
		/// <param name="length"></param>
		/// <param name="jump"></param>
        void Convert(T[] fromArray, int fromIndex, K[] toArray, int toIndex, int length, int jump);

        /// <summary>
        /// Converts array to another
        /// </summary>
        /// <param name="fromArray">Source Array</param>
        /// <returns>Converted Array</returns>
        K[] Convert(T[] fromArray);

        /// <summary>
        /// Information about conversion (is there dataloss, etc...)
        /// </summary>
        ConversionInfo ConversionInfo { get; }        
    }
}
