/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using TPClib.Common;

namespace TPClib.Modeling
{
    /// <summary>
    /// Real valued function: R -> R.
    /// </summary>
    public delegate double SingleValueFunction(double x);

    /// <summary>
    /// Real valued function: R^n -> R.
    /// </summary>
    /// <param name="p">function parameters</param>
	public delegate double RealFunction(Vector p);

    /// <summary>
    /// Real valued function: R^(n+1) -> R at given time point.
    /// </summary>
    /// <param name="t">time point</param>
    /// <param name="p">function parameters</param>
    public delegate double RealFunctionWithTime(double t, Vector p);

	/// <summary>
	/// Some metric R_n x R_n -> R
	/// </summary>
	/// <param name="a">Point in R_n</param>
	/// <param name="b">Point in R_n</param>
	/// <returns>Distance between a and b with this metric</returns>
	public delegate double Metric(Vector a, Vector b);
}
