/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;

namespace TPClib.Modeling
{
    /// <summary>
    /// Event arguments for optimization progress
    /// </summary>
    public class OptimizationProgressEventArgs : EventArgs
    {
        /// <summary>
        /// Goodness Of Fit of current optimization state
        /// </summary>
        public double goodnessOfFit;
        /// <summary>
        /// Additional description, or null.
        /// </summary>
        public string description;
        /// <summary>
        /// Creates new model fitting progress event arguments
        /// </summary>
        public OptimizationProgressEventArgs()
        {
            this.goodnessOfFit = 0.0f;
        }
        /// <summary>
        /// Creates new model fitting progress event arguments
        /// </summary>
        /// <param name="desc">event description</param>
        public OptimizationProgressEventArgs(string desc)
        {
            this.goodnessOfFit = 0.0f;
            this.description = desc;
        }
        /// <summary>
        /// Returns a String that represents the current Object.
        /// </summary>
        /// <returns>A String that represents the current Object.</returns>
        public override string ToString()
        {
            if (description != null)
                return "[" + description + "] progress:" + goodnessOfFit.ToString() + "%";
            else
                return "progress:" + goodnessOfFit.ToString() + "%";
        }
    }
}