/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

namespace TPClib.Modeling.Integrals
{
    /// <summary>
    /// Parent class for all 1D-interpolation methods. 
    /// </summary>
    public abstract class InterpolationMethod
    {
        /// <summary>
        /// Handling type for external values
        /// </summary>
        public enum ExternalValueHandlingMethod {
            /// <summary>
            /// External values are set to zero.
            /// </summary>
            ZERO_VALUES,
            /// <summary>
            /// External values are extrapolated from preceding/following slope.
            /// </summary>
            EXTRAPOLATION,
            /// <summary>
            /// Preceding outside values are set to zero and following outside 
            /// values are extrapolated from preceding slope.
            /// </summary>
            PATLAK
        }

		/// <summary>
		/// Interpolates at tacs points.
		/// </summary>
		/// <param name="x">interpolation locations</param>
		/// <param name="data_x">x-values of tacs</param>
		/// <param name="data_y">y-values of tacs</param>
		/// <param name="m">Extrapolation method</param>
		/// <returns>y-values evaluated at locations x</returns>
        public abstract double[] Interpolate(double[] x, double[] data_x, double[] data_y, ExternalValueHandlingMethod m);
    }
}
