/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;
using TPClib.Image;

namespace TPClib.ROI
{
    /// <summary>
    /// Image Matrix object which is used in arbitrary shaped deformations.
    /// </summary>
    public class Image_Matrix: MatrixObject
    {
        /// <summary>
        /// Image data for this matrix object
        /// </summary>
        public TPClib.Image.Image image;
        /// <summary>
        /// Matrix x-dimension (Width)
        /// </summary>
        public int dimx { get { return image.dimx; } }
        /// <summary>
        /// Matrix y-dimension (Height)
        /// </summary>
        public int dimy { get { return image.dimy; } }
        /// <summary>
        /// Matrix z-dimension (Depth)
        /// </summary>
        public int dimz { get { return image.dimz; } }

        /// <summary>
        /// Constructs VOI_Matrix object
        /// </summary>
        /// <param name="width">Width of matrix</param>
        /// <param name="height">Height of matrix</param>
        /// <param name="depth">Depth of matrix</param>
        public Image_Matrix( int width, int height, int depth )
        {
            image = new TPClib.Image.Image(width, height, depth);
        }

        /// <summary>
        /// Clears all data values.
        /// </summary>
        public override void Clear() {
            image.Multiply(0.0f);
        }
    }
}
