/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;
using TPClib.Image;

namespace TPClib.ROI
{
    /// <summary>
    /// Calculates min values from pixel values
    /// </summary>
    public class ROICalculator_Max : ROICalculator
    {
        private double[] res;


        /// <summary>
        /// Constructs max calculator object with length of 1. All other frames are ignored
        /// </summary>
        public ROICalculator_Max()
        {
            SetLength(1);
        }
        /// <summary>
        /// Constructor that defines number of ROIs.
        /// </summary>
        /// <param name="length">number of ROIs</param>
        public ROICalculator_Max(int length)
        {
            SetLength(length);
        }
        /// <summary>
        /// Adds values to all ROIs.
        /// </summary>
        /// <param name="value">added values</param>
        public override void AddValue(float[] value)
        {
            for (int i = 0; i < Length; i++)
            {
                if (value[i] > res[i]) res[i] = value[i];
            }
        }
        /// <summary>
        /// Gets all calculation results
        /// </summary>
        /// <returns>results as double values</returns>
        public override Double[] GetResult()
        {
            return res;
        }
        /// <summary>
        /// Sets number of ROIs in calculations
        /// </summary>
        /// <param name="length">new number of ROIs</param>
        public override void SetLength(int length)
        {
            Length = length;
            res = new double[Length];
            for (int i = 0; i < Length; i++) res[i] = double.MinValue;
        }
    }
}