/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;

namespace TPClib.ROI
{
    public class ROIFileHeader
    {
        /// <summary>
        /// Name of image file
        /// </summary>
        public String ImageFile = ".";
        /// <summary>
        /// Raw file that was used when creating ROI
        /// </summary>
        public String RawImage = ".";
        /// <summary>
        /// ROI set name.
        /// </summary>
        public String Name = ".";
        /// <summary>
        /// ROI set orientation.
        /// </summary>
        public String Orientation = ".";
        /// <summary>
        /// Orientation code.
        /// </summary>
        public int Orient = 0;
        /// <summary>
        /// Width of the reference image.
        /// </summary>
        public int Resolution_X = 0;
        /// <summary>
        /// Height of the reference image.
        /// </summary>
        public int Resolution_Y = 0;
        /// <summary>
        /// Number of planes of the reference image.
        /// </summary>
        public int Resolution_Z = 0;
        /// <summary>
        /// Voxel x-size of the reference image.
        /// </summary>
        public Double VoxelDimension_X = 0.0;
        /// <summary>
        /// Voxel y-size of the reference image.
        /// </summary>
        public Double VoxelDimension_Y = 0.0;
        /// <summary>
        /// Voxel z-size of the reference image.
        /// </summary>
        public Double VoxelDimension_Z = 0.0;
        /// <summary>
        /// Flag for flipping around x-axis while drawing the ROI
        /// </summary>
        public bool Flip_X = true;
        /// <summary>
        /// Flag for flipping around y-axis while drawing the ROI
        /// </summary>
        public bool Flip_Y = false;
        /// <summary>
        /// Flag for flipping around z-axis while drawing the ROI
        /// </summary>
        public bool Flip_Z = false;
        /// <summary>
        /// ROI set x-origin.
        /// </summary>
        public int Ori_X = 0;
        /// <summary>
        /// ROI set y-origin.
        /// </summary>
        public int Ori_Y = 0;
        /// <summary>
        /// ROI set z-origin.
        /// </summary>
        public int Ori_Z = 0;
        /// <summary>
        /// Free comment field.
        /// </summary>
        public String Comment = ".";
    }
}
