/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;
using TPClib.Common;

namespace TPClib.ROI
{
    /// <summary>
    /// ROIPoint which can contain also a pixel value
    /// </summary>
    public class ROIValuePoint : Point
    {
        /// <summary>
        /// Image intensity value at point location
        /// </summary>
        public Double Value;
        /// <summary>
        /// Frame index
        /// </summary>
        public Double Frame;
        /// <summary>
        /// Constructor with location parameters.
        /// </summary>
        /// <param name="xx">x-coordinate</param>
        /// <param name="yy">y-coordinate</param>
        /// <param name="zz">z-coordinate</param>
        /// <param name="frame">frame index</param>
        public ROIValuePoint(int xx, int yy, int zz, int frame)
        {
            X = xx;
            Y = yy;
            Z = zz;
            Frame = frame;
            Value = 0.0d;
        }
        /// <summary>
        /// Constructor with location parameters as real numbers
        /// </summary>
        /// <param name="xx">x-coordinate</param>
        /// <param name="yy">y-coordinate</param>
        /// <param name="zz">z-coordinate</param>
        /// <param name="frame">frame index</param>
        public ROIValuePoint(Double xx, Double yy, Double zz, Double frame)
        {
            X = xx;
            Y = yy;
            Z = zz;
            Frame = frame;
            Value = 0.0d;
        }
        /// <summary>
        /// Constructor with location parameters as real numbers
        /// </summary>
        /// <param name="xx">x-coordinate</param>
        /// <param name="yy">y-coordinate</param>
        /// <param name="zz">z-coordinate</param>
        /// <param name="frame">frame index</param>
        /// <param name="val">intensity value at location</param>
        public ROIValuePoint(Double xx, Double yy, Double zz, Double frame, Double val)
        {
            X = xx;
            Y = yy;
            Z = zz;
            Frame = frame;
            Value = val;
        }
        /// <summary>
        /// Constructor with location parameters.
        /// </summary>
        /// <param name="xx">x-coordinate</param>
        /// <param name="yy">y-coordinate</param>
        /// <param name="zz">z-coordinate</param>
        /// <param name="frame">frame index</param>
        /// <param name="val">intensity value at location</param>
        public ROIValuePoint(int xx, int yy, int zz, int frame, Double val)
        {
            X = xx;
            Y = yy;
            Z = zz;
            Frame = frame;
            Value = val;
        }
        /// <summary>
        /// Returns a String that represents the current Object.
        /// </summary>
        /// <returns>A String that represents the current Object.</returns>
        public override string ToString()
        {
            return "[" + X.ToString("f2") + "  " + Y.ToString("f2") + "  " + Z.ToString("f2") + "  " + Frame.ToString("f2") + "] = " + Value.ToString("f3");
        }
    }
}