/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;
using TPClib.Image;

namespace TPClib.ROI
{
    /// <summary>
    /// Volume of interest (VOI) class is a 3D volume that contains many 2D ROIs. VOI class
    /// handles the filling of VOIMatrix object, which is the matrix containing the region of interest
    /// information. It can be retrieved with GetMatrix() method.
    /// </summary>
    public abstract class VOI : Maskable
    {
        /// <summary>
        /// Name of VOI
        /// </summary>
        public String Name = "";
        /// <summary>
        /// RGB Color code of VOI, consisting of 3 values n {0..255}, default == {000,000,000} (black)
        /// </summary>        
        private byte[] color = new byte[3];
        /// <summary>
        /// RGB Color code of VOI, consisting of 3 values n {0..255}
        /// </summary>        
        public byte[] Color {
            get { return color; }
            set { 
                if (value.Length != 3)
                    throw new InvalidOperationException("RGB color must have exactly 3 values");
                color = value;
            }
        }

        /// <summary>
        /// Returns a String that represents the current Object.
        /// </summary>
        /// <returns>A String that represents the current Object.</returns>
        public override string ToString()
        {
            return "VOI[name="+Name+" color="+color[0]+","+color[1]+","+color[2]+"]";
        }
    }
}
