/********************************************************************************
*                                                                               *
*  TPCDicom 0.1 Dicom I/O library                                               *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
*  TPCDicom is based on the openDicom# 0.1.1 library.                           *
*                                                                               *
*  *** openDicom license ***                                                    *
*                                                                               *
*  openDICOM.NET openDICOM# 0.1.1                                               *
*                                                                               *
*  openDICOM# provides a library for DICOM related development on Mono.         *
*  Copyright (C) 2006-2007  Albert Gnandt                                       *
*                                                                               *
*  This library is free software; you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License as published by     *
*  the Free Software Foundation; either version 2.1 of the License, or (at      *
*  your option) any later version.                                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public       *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this library; if not, write to the                                *
*  Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA      *
*  02110-1301 USA                                                               *
*                                                                               *
********************************************************************************/

using System;
using TPCDicom.DataStructure;
using TPCDicom.Encoding.Type;
using System.Text.RegularExpressions;


namespace TPCDicom.Encoding
{

    /// <summary>
    ///     This class represents the specific DICOM VR Age String (AS).
    /// </summary>
    public sealed class AgeString: ValueRepresentation
    {
        /// <summary>
        /// Constructor with tag value
        /// </summary>
        /// <param name="tag">corresponding tag value</param>
        public AgeString(Tag tag) : base("AS", tag) { }

        /// <summary>
        /// String description about this object.
        /// </summary>
        /// <returns></returns>
        public override string ToLongString()
        {
            return "Age String (AS)";
        }

        /// <summary>
        /// Converts byte array 
        /// </summary>
        /// <param name="bytes">input array</param>
        /// <returns>array of strings containing AS value</returns>
        protected override Array DecodeImproper(byte[] bytes)
        {
            string s = TransferSyntax.ToString(bytes);
            string[] multiValue = ToImproperMultiValue(s);
            Age[] age = new Age[multiValue.Length];
            for (int i = 0; i < age.Length; i++)
            {
                string item = multiValue[i];
                try
                {
                    if (item == null || item.Equals(""))
                        item = "000D";
                    age[i] = new Age(item);
                }
                catch (Exception)
                {
                    throw new EncodingException("Age string format is invalid.",
                        Name + "/item", item);
                }
            }
            return age;
        }

        /// <summary>
        /// Converts byte array 
        /// </summary>
        /// <param name="bytes">input array</param>
        /// <returns>array of strings containing AS value</returns>
        protected override Array DecodeProper(byte[] bytes)
        {
            string s = TransferSyntax.ToString(bytes);
            string[] multiValue = ToProperMultiValue(s);
            Age[] age = new Age[multiValue.Length];
            for (int i = 0; i < age.Length; i++)
            {
                string item = multiValue[i];
                try
                {
                    age[i] = new Age(item);
                }
                catch (Exception)
                {
                    throw new EncodingException("Age string format is invalid.",
                        Name + "/item", item);
                }
            }
            return age;
        }
    }

}
