/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

namespace TPClib
{
	/// <summary>
	/// 
	/// </summary>
    public interface Ifile
    {
        /// <summary>
        /// Reads tacs from file.
        /// </summary>
        void ReadFile();

		/// <summary>
        /// Writes tacs into file.
        /// </summary>
        void WriteFile();
    }

    /// <summary>
    /// General interface for all files that can be read and written.
    /// </summary>
    public abstract class TPCFile
    {
        /// <summary>
        /// Full URL (Unified Resource Locator) to file.
        /// </summary>
        public string filename;
        /// <summary>
        /// Reads data from file.
        /// <seealso cref="filename"/>
        /// </summary>
        public abstract void ReadFile();
        /// <summary>
        /// Writes data into file.
        /// <seealso cref="filename"/>
        /// </summary>
        public abstract void WriteFile();
    }
}
