/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

namespace TPClib
{
    /// <summary>
    /// Thrown when unit test fails.
    /// </summary>
    public class TPCUnitTestFailedException : TPCException
    {
        /// <summary>
        /// Failed method's name
        /// </summary>
        string methodname;
        /// <summary>
        /// Failed methods arguments.
        /// </summary>
        string arguments;
        /// <summary>
        /// Constructs TPC exception for arguments
        /// </summary>
        /// <param name="m">message string</param>
        /// <param name="methodname">method which failed, or ""</param>
        /// <param name="arguments">arguments that were used, or ""</param>
        public TPCUnitTestFailedException(string m, string methodname, string arguments)
            : base(m)
        {
            this.methodname = methodname;
            this.arguments = arguments;
        }
    }
}