/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

namespace TPClib.Curve
{
    /// <summary>
    /// Enumeration for file type
    /// </summary>
    public enum CurveFileType
    {
        /// <summary>
        /// Unknown DFT file
        /// </summary>
        Unknown_DFT = 0,
        /// <summary>
        /// Regional DFT file 
        /// </summary>
        Regional_DFT, 
        /// <summary>
        /// Plasma DFt file
        /// </summary>
        Plasma_DFT,
        /// <summary>
        /// Plasma Tima Activity Curve (TAC) file format (Imanet Hammersmith)
        /// </summary>
        IF,
        /// <summary>
        /// Regional Time Activity Curve (TAC) file format (CTI Imagetool, Vinci)
        /// </summary>
        CPT,
        /// <summary>
        /// Regional Time Activity Curve (TAC) file format in XML
        /// </summary>
        XML,
        /// <summary>
        /// Regional Time Activity Curve (TAC) file format (Imanet Hammersmith)
        /// </summary>
        IDWC
    }
}