/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;

/// <summary>
/// Class defining attribute to be used as expected results for a test case
/// </summary>
[AttributeUsage(AttributeTargets.Method)]
public class ExpectedResultsAttribute : Attribute
{
    /// <summary>
    /// Constructor with parameter
    /// </summary>
    /// <param name="Description_in">expected description for test case method</param>
    public ExpectedResultsAttribute(String Description_in)
    {
        this.description = Description_in;
    }
    /// <summary>
    /// Internal descrition string
    /// </summary>
    protected String description;
    /// <summary>
    /// Expected results for a test case
    /// </summary>
    public String ResultDescription
    {
        get
        {
            return this.description;
        }
    }
}
