/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

namespace TPClib.Image
{
    /// <summary>
    /// Filetype that 
    /// </summary>
    public enum FileType
    {
        /// <summary>
        /// Ecat7 format
        /// </summary>
        Ecat7,
        /// <summary>
        /// DICOM format
        /// </summary>
        DICOM,
        /// <summary>
        /// Analyze 7.5 format
        /// </summary>
        Analyze75,
        /// <summary>
        /// Micro PET scanner format
        /// </summary>
        MicroPET,
        /// <summary>
        /// Interfile format
        /// </summary>
        Interfile,
		/// <summary>
		/// Nifti-1 format
		/// </summary>
		Nifti
    }
}
