/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

namespace TPClib.Image
{
    /// <summary>
    /// This class calculates coordinates of n dimensional cube
    /// to indexes one dimensional large Array and vice versa
    /// </summary>
    public class CubeCoordinatorCalculator
    {
        private uint[] dims;
        private int numDims;
        private long[] dimensionLengths;

		/// <summary>
		/// 
		/// </summary>
		/// <param name="dimensions"></param>
        public CubeCoordinatorCalculator(uint[] dimensions)
        {
            dims = dimensions;
            numDims = dimensions.Length;

            dimensionLengths = new long[numDims];
            dimensionLengths[0] = 1;

            long startNum = 1;
            long FullLength = (long)dimensions[0];
            for (int i = 1; i < dimensions.Length; i++)
            {
                FullLength *= (long)dimensions[i];
                startNum *= (long)dimensions[i - 1];
                dimensionLengths[i] = startNum;
            }
        }

        /// <summary>
        /// Calculates the coordinates of index of large 1 dimensional Array
        /// </summary>
        /// <param name="position">Index of large 1 dimensional Array</param>
        /// <returns>The coordinates</returns>
        public uint[] CalculatePosition(long position)
        {
            uint[] coordinates = new uint[numDims];
            uint val;
            for (int i = numDims - 1; i >= 0; i--)
            {
                val = (uint)(position / dimensionLengths[i]);
                coordinates[i] = val;
                position -= (long)val * dimensionLengths[i];
            }
            return coordinates;
        }
    }

}
