/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace TPClib.Image.ValueScales
{
    /// <summary>
    /// This class describing the scale of the values
    /// </summary>
    /// <typeparam name="T">Type of values</typeparam>
    public class ValueScale<T> where T : struct, IConvertible, IComparable
    {

        private T min;
        private T max;
        private bool minMaxGiven = false;

        private double factorToReal = 1.0d;
        private double intersectionToReal = 0.0d;
        internal double Factor { get { return factorToReal; } }
        internal double Intersection { get { return intersectionToReal; } }

        internal void SetMinMax(T min, T max) { minMaxGiven = true; this.min = min; this.max = max; }

		/// <summary>
		/// 
		/// </summary>
        public bool MinMaxGiven { get { return minMaxGiven; } }
        
		/// <summary>
		/// 
		/// </summary>
		public T Min { get { return min; } }
        
		/// <summary>
		/// 
		/// </summary>
		public T Max { get { return max; } }

        /// <summary>
        /// Gets converter from this type to given type
        /// </summary>
        /// <typeparam name="K">ValueType of the destination scale</typeparam>
        /// <param name="destination">The destination scale</param>
        /// <returns></returns>
        public IConverter<T, K> GetConverter<K>(ValueScale<K> destination) where K : struct, IConvertible, IComparable
        {
            return ConverterFactor.Create<T, K>(this, destination);
        }

		/// <summary>
		/// 
		/// </summary>
        public ValueScale() {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="min"></param>
		/// <param name="max"></param>
        public ValueScale(T min, T max)
        {
            this.min = min;
            this.max = max;
            this.minMaxGiven = true;
        }

		/// <summary>
		/// 
		/// </summary>
		/// <param name="factor"></param>
		/// <param name="intersection"></param>
        public ValueScale(double factor, double intersection)
        {
            this.factorToReal = factor;
            this.intersectionToReal = intersection;
        }

		/// <summary>
		/// 
		/// </summary>
		/// <param name="min"></param>
		/// <param name="max"></param>
		/// <param name="factor"></param>
		/// <param name="intersection"></param>
        public ValueScale(T min, T max, double factor, double intersection)
        {
            this.min = min;
            this.max = max;
            this.minMaxGiven = true;
            this.factorToReal = factor;
            this.intersectionToReal = intersection;
        }

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
        public object Clone()
        {
            ValueScale<T> map = new ValueScale<T>();
            map.SetMinMax(this.Min, this.Max);
            map.factorToReal = this.factorToReal;
            map.intersectionToReal = this.intersectionToReal;
            return map;
        }
    }
}
