/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using TPClib.Common;

namespace TPClib
{
    /// <summary>
    /// Point containing only integer values
    /// </summary>
    public class IntPoint : Point
    {
        /// <summary>
        /// x-coordinate, (input/output)
        /// </summary>
        public new int X
        {
            get { return (int)base.X; }
            set { base.X = (int)value; }
        }
        
		/// <summary>
        /// y-coordinate, (input/output)
        /// </summary>
        public new int Y
        {
            get { return (int)base.Y; }
            set { base.Y = (int)value; }
        }
        
		/// <summary>
        /// z-coordinate, (input/output)
        /// </summary>
        public new int Z
        {
            get { return (int)base.Z; }
            set { base.Z = (int)value; }
        }
        
		/// <summary>
        /// Constructs point at specified location.
        /// </summary>
        /// <param name="x">x-coordinate</param>
        /// <param name="y">y-coordinate</param>
        /// <param name="z">z-coordinate</param>
        public IntPoint(int x, int y, int z)
            : base(x, y, z)
        {
        }
        
		/// <summary>
        /// Constructs point at specified location.
        /// </summary>
        /// <param name="p">location</param>
        public IntPoint(IntPoint p)
        {
            this.X = p.X;
            this.Y = p.Y;
            this.Z = p.Z;
        }
        
		/// <summary>
        /// Constructs point at location (0, 0, 0)
        /// </summary>
        public IntPoint() : base() { }
        
		/// <summary>
        /// Sets point location
        /// </summary>
        /// <param name="x">x-coordinate</param>
        /// <param name="y">y-coordinate</param>
        /// <param name="z">z-coordinate</param>
        public new void Set(int x, int y, int z)
        {
            this.X = x;
            this.Y = y;
            this.Z = z;
        }
        
		/// <summary>
        /// Sets point location.
        /// </summary>
        /// <param name="p">new location</param>
        public void Set(IntPoint p)
        {
            this.X = p.X;
            this.Y = p.Y;
            this.Z = p.Z;
        }
        
		/// <summary>
        /// Returns a String that represents the current Object.
        /// </summary>
        /// <returns>A String that represents the current Object.</returns>
        public override string ToString()
        {
            return base.ToString() + "(" + X + ", " + Y + ", " + Z + ")";
        }

		/// <summary>
        /// Addition operator
        /// </summary>
        /// <param name="p1">1st addition term point</param>
        /// <param name="p2">2nd addition term point</param>
        public static IntPoint operator +(IntPoint p1, IntPoint p2)
        {
            IntPoint r = new IntPoint();
            r.X = p1.X + p2.X;
            r.Y = p1.Y + p2.Y;
            r.Z = p1.Z + p2.Z;
            return r;
        }
    }
}
