/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using TPClib.Common;

namespace TPClib.Modeling
{
	/// <summary>
	/// Linear regression model
	/// </summary>
	[Model(Name = @"Straight line model", Description = @"Simple linear model: y=kx+b", Category=ModelAttribute.ClassCategory.TEST)]
	public class StraightLine : BaseModel
	{
		/// <summary>
		/// Reference times
		/// </summary>
		[Input(Name = @"Reference points", Optional = false)]
		public ISeries ReferencePoints;

		/// <summary>
		/// Linear slope
		/// </summary>
		[Parameter(Name = @"Slope", Description = @"Slope")]
		public OptimizationParameter Slope = 0;

		/// <summary>
		/// Linear intercept
		/// </summary>
		[Parameter(Name = @"Intercept", Description = @"Baseline")]
		public OptimizationParameter Intercept = 0;

		/// <summary>
		/// Result plot
		/// </summary>
		[Output(Name = @"Result")]
		public Plot Result;

		/// <summary>
		/// Number of samples simulated
		/// </summary>
		public int Samples
		{
			get { return ReferencePoints.Count; }
		}

		/// <summary>
		/// Initialize
		/// </summary>
		public override void Init()
		{
			Result = new Plot(new DataSeries(Samples), ReferencePoints);
		}

		/// <summary>
		/// Simulate data using the current model parameters
		/// </summary>
		/// <returns></returns>
		public override DataSeries Simulate()
		{
			for (int i = 0; i < Samples; i++)
				Result[i] = Intercept + ReferencePoints[i] * Slope;

			return Result;
		}
	}
}
