/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using TPClib.Common;

namespace TPClib.Modeling
{
    /// <summary>
    /// 
    /// </summary>
    public class Linemethod
    {
        private SingleValueFunction f;
        private double brentTol;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="f"></param>
        /// <param name="tol"></param>
        public Linemethod(SingleValueFunction f, double tol)
        {
            this.f = f;
            this.brentTol = tol;
        }

        /// <summary>
        /// Line minimization.
        /// </summary>
        /// <param name="point">Point</param>
        /// <param name="xi">Direction</param>
        /// <returns>the minimum function value</returns>
		public double LineMinimum(ref Vector point, ref Vector xi)
        {
            if (point.Length != xi.Length)
                throw new OptimizationException("LineMinimum: Wrong argument");

            double a, x, b, fa, fx, fb, xmin, fmin;

            Brent brent = new Brent();

            // initial guess for brackets
            double inita = 0, initb = 1;

            // bracket to minimum
            brent.Bracket(inita, initb, f, out a, out x, out b, out fa, out fx, out fb);

            // Now, do the parabolic interpolation.
            fmin = brent.Minimize(a, x, b, brentTol, f, out xmin);

            // update minimized point and direction
            xi = xi * xmin;
            point = point + xi;

            return fmin;
        }
    }
}
