/********************************************************************************
*                                                                               *
*  TPClib 0.9 Medical imaging library                                           *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
********************************************************************************/

using System;

namespace TPClib
{
    /// <summary>
    /// Event arguments for process actions that have some finite way to measure progress (in percents).
    /// </summary>
    public class ProgressEventArgs : EventArgs
    {
        /// <summary>
        /// Creates new event arguments
        /// </summary>
        protected ProgressEventArgs()
        {
            this.percent = 0.0f;
            this.method = null;
        }
        /// <summary>
        /// Creates new event arguments
        /// </summary>
        /// <param name="percent">estimated percent of operation ready 100.0 ready</param>
        /// <param name="method">method where event occurred</param>
        /// <param name="desc">additional description of current process</param>
        public ProgressEventArgs(float percent, System.Reflection.MethodBase method, string desc)
        {
            this.percent = percent;
            this.method = method;
            this.description = desc;
        }
        /// <summary>
        /// Creates new event arguments
        /// </summary>
        /// <param name="percent">estimated percent of operation ready 100.0 ready</param>
        /// <param name="method">method where event occurred</param>
        public ProgressEventArgs(float percent, System.Reflection.MethodBase method)
        {
            this.percent = percent;
            this.method = method;
        }
        /// <summary>
        /// Method where event occurred
        /// </summary>
        public System.Reflection.MethodBase method;
        /// <summary>
        /// Estimated percent (in [0.0 .. 100.0]) ready from operation
        /// </summary>
        public float percent;
        /// <summary>
        /// Additional description, or null.
        /// </summary>
        public string description;
        /// <summary>
        /// Prints out basic information about progress event.
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            if (description != null)
                return "[" + method.Name + "] [" + description + "] progress:" + percent.ToString() + "%";
            else
                return "[" + method.Name + "] progress:" + percent.ToString() + "%";
        }
    }
}