/********************************************************************************
*                                                                               *
*  TPCDicom 0.1 Dicom I/O library                                               *
*  Copyright (C) 2011 Turku PET Centre                                          *
*                                                                               *
*  This library is free software: you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License (LGPL) as           *
*  published by the Free Software Foundation, either version 2.1 of the         *
*  License, or (at your option) any later version.                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public      *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this program.  If not, see <http://www.gnu.org/licenses/>.        *
*                                                                               *
*  TPCDicom is based on the openDicom# 0.1.1 library.                           *
*                                                                               *
*  *** openDicom license ***                                                    *
*                                                                               *
*  openDICOM.NET openDICOM# 0.1.1                                               *
*                                                                               *
*  openDICOM# provides a library for DICOM related development on Mono.         *
*  Copyright (C) 2006-2007  Albert Gnandt                                       *
*                                                                               *
*  This library is free software; you can redistribute it and/or modify it      *
*  under the terms of the GNU Lesser General Public License as published by     *
*  the Free Software Foundation; either version 2.1 of the License, or (at      *
*  your option) any later version.                                              *
*                                                                               *
*  This library is distributed in the hope that it will be useful, but          *
*  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY   *
*  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public       *
*  License for more details.                                                    *
*                                                                               *
*  You should have received a copy of the GNU Lesser General Public License     *
*  along with this library; if not, write to the                                *
*  Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA      *
*  02110-1301 USA                                                               *
*                                                                               *
********************************************************************************/

using System;
using TPCDicom;
using TPCDicom.DataStructure;


namespace TPCDicom.Encoding
{

    /// <summary>
    ///     Parent class for all encoding exceptions.
    /// </summary>
    public class EncodingException: DicomException
    {
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        public EncodingException(string paramName, string paramValue): 
            base("An encoding exception occurred.", paramName, paramValue, 
                null) {}
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        /// <param name="innerException">inner exception that has occurred</param>
        public EncodingException(string paramName, string paramValue,
            Exception innerException): 
            base("An encoding exception occurred.", paramName, paramValue, 
                innerException) {}
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="message">description of exception</param>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        public EncodingException(string message, string paramName, 
            string paramValue): 
            base(message, paramName, paramValue) {}
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="message">description of exception</param>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        /// <param name="innerException">inner exception that has occurred</param>
        public EncodingException(string message, string paramName, 
            string paramValue, Exception innerException): 
            base(message, paramName, paramValue, innerException) {}
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="message">description of exception</param>
        /// <param name="streamPosition">stream position where exception occurred</param>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        public EncodingException(string message, long streamPosition, 
            string paramName, string paramValue):
            base(message, streamPosition, paramName, paramValue) {}
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="message">description of exception</param>
        /// <param name="streamPosition">stream position where exception occurred</param>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        /// <param name="innerException">inner exception that has occurred</param>
        public EncodingException(string message, long streamPosition, 
            string paramName, string paramValue, Exception innerException):
            base(message, streamPosition, paramName, paramValue, 
                innerException) {}
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="message">description of exception</param>
        /// <param name="tag">tag where exception occurred</param>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        public EncodingException(string message, Tag tag, string paramName, 
            string paramValue):
            base(message, tag, paramName, paramValue) {}
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="message">description of exception</param>
        /// <param name="tag">tag where exception occurred</param>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        /// <param name="innerException">inner exception that has occurred</param>
        public EncodingException(string message, Tag tag, string paramName, 
            string paramValue, Exception innerException):
            base(message, tag, paramName, paramValue, innerException) {}
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="message">description of exception</param>
        /// <param name="tag">tag where exception occurred</param>
        /// <param name="streamPosition">stream position where exception occurred</param>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        public EncodingException(string message, Tag tag, long streamPosition,
            string paramName, string paramValue):
            base(message, tag, streamPosition, paramName, paramValue) {}
        /// <summary>
        /// Creates encoding exception instance.
        /// </summary>
        /// <param name="message">description of exception</param>
        /// <param name="tag">tag where exception occurred</param>
        /// <param name="streamPosition">stream position where exception occurred</param>
        /// <param name="paramName">name of an additional parameter</param>
        /// <param name="paramValue">value of an additional parameter</param>
        /// <param name="innerException">inner exception that has occurred</param>
        public EncodingException(string message, Tag tag, long streamPosition,
            string paramName, string paramValue, Exception innerException):
            base(message, tag, streamPosition, paramName, paramValue, 
                innerException) {}
    }

}
