/*
   
    openDICOM.NET openDICOM# 0.1.1

    openDICOM# provides a library for DICOM related development on Mono.
    Copyright (C) 2006-2007  Albert Gnandt

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA


    $Id: AcrNemaFile.cs 48 2007-03-28 13:49:15Z agnandt $

    This is a modified version of original library for Turku PET Centre 2011
*/
using System;
using System.Collections.Generic;
using System.Text;

namespace openDicom
{
    /// <summary>
    /// Dicom tag tacs type
    /// </summary>
    public enum VR
    {
        /// <summary>
        /// AE Application Entity
        /// </summary>
        AE = ('A' << 8) | 'E',
        /// <summary>
        /// AS Age String
        /// </summary>
        AS = ('A' << 8) | 'S',
        /// <summary>
        /// AT Attribute String
        /// </summary>
        AT = ('A' << 8) | 'T',
        /// <summary>
        /// CS Code String
        /// </summary>
        CS = ('C' << 8) | 'S',
        /// <summary>
        /// DA Date
        /// </summary>
        DA = ('D' << 8) | 'A',
        /// <summary>
        /// DS Decimal String
        /// </summary>
        DS = ('D' << 8) | 'S',
        /// <summary>
        /// DT Date/Time
        /// </summary>
        DT = ('D' << 8) | 'T',
        /// <summary>
        /// FL 4-byte float value
        /// </summary>
        FL = ('F' << 8) | 'L',
        /// <summary>
        /// FD 8-byte float value
        /// </summary>
        FD = ('F' << 8) | 'D',
        /// <summary>
        /// IS Integer String
        /// </summary>
        IS = ('I' << 8) | 'S',
        /// <summary>
        /// LO Long String
        /// </summary>
        LO = ('L' << 8) | 'O',
        /// <summary>
        /// LT Long Text
        /// </summary>
        LT = ('L' << 8) | 'T',
        /// <summary>
        /// OB Other Byte, binary data
        /// </summary>
        OB = ('O' << 8) | 'B',
        /// <summary>
        /// OW Other word
        /// </summary>
        OW = ('O' << 8) | 'W',
        /// <summary>
        /// PN Person Name
        /// </summary>
        PN = ('P' << 8) | 'N',
        /// <summary>
        /// SH Short String
        /// </summary>
        SH = ('S' << 8) | 'H',
        /// <summary>
        /// SL Signed Long
        /// </summary>
        SL = ('S' << 8) | 'L',
        /// <summary>
        /// SQ Squence of Items
        /// </summary>
        SQ = ('S' << 8) | 'Q',
        /// <summary>
        /// SS Signed Short
        /// </summary>
        SS = ('S' << 8) | 'S',
        /// <summary>
        /// ST Short Text
        /// </summary>
        ST = ('S' << 8) | 'T',
        /// <summary>
        /// TM Time
        /// </summary>
        TM = ('T' << 8) | 'M',
        /// <summary>
        /// UI Unique Identifier
        /// </summary>
        UI = ('U' << 8) | 'I',
        /// <summary>
        /// UL Unsigned Long
        /// </summary>
        UL = ('U' << 8) | 'L',
        /// <summary>
        /// US Unsigned Short
        /// </summary>
        US = ('U' << 8) | 'S',
        /// <summary>
        /// UN Unknown
        /// </summary>
        UN = ('U' << 8) | 'N',
        /// <summary>
        /// UT Unlimited Text
        /// </summary>
        UT = ('U' << 8) | 'T',
        /// <summary>
        /// special tag (choices)
        /// </summary>
        ox = ('o' << 8) | 'x'
    }
}
