/*
   
    openDICOM.NET openDICOM# 0.1.1

    openDICOM# provides a library for DICOM related development on Mono.
    Copyright (C) 2006-2007  Albert Gnandt

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA


    $Id: AcrNemaFile.cs 48 2007-03-28 13:49:15Z agnandt $

    This is a modified version of original library for Turku PET Centre 2011
*/
using System;
using openDicom.DataStructure;

namespace openDicom.Encoding
{

    /// <summary>
    ///     This class represents the specific DICOM VR Long String (LO).
    /// </summary>
    public sealed class LongString: ValueRepresentation
    {
        /// <summary>
        /// Constructor with tag value
        /// </summary>
        /// <param name="tag">corresponding tag value</param>
        public LongString(Tag tag) : base("LO", tag) { }

        /// <summary>
        /// String description about this object.
        /// </summary>
        /// <returns></returns>
        public override string ToLongString()
        {
            return "Long String (LO)";
        }

        /// <summary>
        /// Converts byte array. 
        /// </summary>
        /// <param name="bytes">input array</param>
        /// <returns>array of strings containing LO value</returns>
        protected override Array DecodeImproper(byte[] bytes)
        {
            string s = TransferSyntax.ToString(bytes);
            string[] longString = ToImproperMultiValue(s);
            for (int i = 0; i < longString.Length; i++)
            {
                string item = longString[i];
                //fix control characters out, except ESC (27)
                char[] chars = item.ToCharArray();
                for (int j = 0; j < chars.Length; j++)
                    if (Char.IsControl(chars[j]) && chars[j] != 27) chars[j] = ' ';
                item = new string(chars);
                longString[i] = item.Trim();
            }
            return longString;
        }

        /// <summary>
        /// Converts byte array. 
        /// </summary>
        /// <param name="bytes">input array</param>
        /// <returns>array of strings containing LO value</returns>
        protected override Array DecodeProper(byte[] bytes)
        {
            string s = TransferSyntax.ToString(bytes);
            string[] longString = ToProperMultiValue(s);
            for (int i = 0; i < longString.Length; i++)
            {
                string item = longString[i];
                //fix control characters out, except ESC (27)
                char[] chars = item.ToCharArray();
                for (int j = 0; j < chars.Length; j++)
                    if (Char.IsControl(chars[j]) && chars[j] != 27) chars[j] = ' ';
                item = new string(chars);
                if (item.Length <= 64)
                    longString[i] = item.Trim();
                else
                    throw new EncodingException(
                        "A value of max. 64 characters is only allowed.",
                        Tag, Name + "/item", item);
            }
            return longString;
        }
    }

}
