/******************************************************************************

  Copyright (c) 2007-2013 Turku PET Centre

  File:        csv.h
  Library:     csv
  Description: I/O functions for CSV files (comma-separated values).

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details:
  http://www.gnu.org/copyleft/lesser.html

  You should have received a copy of the GNU Lesser General Public License
  along with this library/program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  Turku PET Centre hereby disclaims all copyright interest in the program.
  Juhani Knuuti
  Director, Professor
  Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/

  Modification history:
  2007-05-15 Vesa Oikonen
    First created.
  2010-04-25 VO
    Added csv2dft().
  2011-02-17 VO
    Added csv2dft_a() and csv2dft_b().
  2013-10-07 VO
    Added csv2dft_linkset().

  

******************************************************************************/
#ifndef _CSV_H
#define _CSV_H
/*****************************************************************************/

/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
/*****************************************************************************/
#include "dft.h"
/*****************************************************************************/

/*****************************************************************************/
enum {CSV_OK, CSV_ERROR, CSV_CANNOTOPEN, CSV_INVALIDFORMAT, CSV_TOOBIG,
    CSV_OUTOFMEMORY, CSV_NOTABLE
    };
/*****************************************************************************/
int CSV_TEST;
/*****************************************************************************/

/*****************************************************************************/
typedef struct {
  int row;
  int col;
  char *content;
} CSV_item;
typedef struct {
  CSV_item *c;
  int nr;
  int row_nr;
  /** max column number per row */
  int col_nr;
  char separator;
} CSV;
/*****************************************************************************/

/*****************************************************************************/
extern void csvInit(CSV *csv);
extern void csvEmpty(CSV *csv);
extern int csvRead(CSV *csv, char *fname);
extern int csv2dft(CSV *csv, DFT *dft);
extern int csv2dft_a(CSV *csv, DFT *dft);
extern int csv2dft_b(CSV *csv, DFT *dft);
extern int csv2dft_linkset(CSV *csv, DFT *dft);
/*****************************************************************************/

/*****************************************************************************/
#endif
