/******************************************************************************
  Copyright (c)  2001-2013 by Turku PET Centre

  File: dft.h

  Date:
  2001-03-25 Vesa Oikonen
  2003-06-19 VO
  2003-08-13 VO
  2003-12-05 KS & VO
  2004-01-26 VO
  2004-05-23 VO
    Doxygen style comments.
  2004-05-25 VO
  2004-07-26 VO
    Better Doxygen style comments.
  2004-08-17 VO
  2004-08-23 VO
    Function names with *DFT end changed to start with dft*.
    MAX_STUDYNR_LEN applied.
  2004-09-05 VO
    Field "name" added to Voi struct.
  2004-12-09 VO
    See dft.c.
  2005-10-30 VO
    Introduces dft_fill_hdr_from_IFT().
    Added to DFT the fields radiopharmaceutical, isotope,
    decayCorrected, scanStartTime, and injectionTime.
  2006-07-12 VO
    See dft.c.
  2007-01-11 VO
    Introduces new functions.
  2007-02-10 VO
    Functions dftMin2sec() and dftSec2min were moved to a new file dftunit.h.
    Changed comments about timeunit.
    I/O functions were moved to a new file dftio.h.
  2007-04-13 VO
    Introduces new function.
  2007-08-09 VO
    See dft.c.
  2007-08-13 VO
    Units length in DFT struct is defined as MAX_UNITS_LEN+1 (previously 13).
  2008-07-14 VO
    Added dftSelectBestReference() and dftAllocateWithHeader().
  2009-06-09 VO
    Added dftFillInitialGap().
  2010-04-12 VO
    Added dftAddSpaceForFrames().
  2010-10-11 VO
    Added dftMinMaxTAC().
  2011-01-26 VO
    Added dftMaxY().
  2012-02-28 VO
    Added defines for filetype, timetype, and decay correction.
  2012-06-19 VO
    Additional parameters for dftMinMaxTAC().
  2012-09-28 VO
    Added dftRNameSimplify().
    DFT struct applies defined value MAX_REGIONSUBNAME_LEN.
  2012-10-25 VO
    Added function dftRemoveTimeRange().
  2012-10-30 VO
    Added function dftMeanTAC().
  2013-06-17 VO
    Added function dftCopymainhdr2() from dftcat 1.4.5.


******************************************************************************/
#ifndef _DFT_H
#define _DFT_H
/*****************************************************************************/
#include "studynr.h"
#include "rname.h"
#include "petunits.h"
/*****************************************************************************/
#ifndef DFT_VER
#define DFT_VER "DFT1"
#endif
#ifndef _DFT_COMMENT_LEN
#define _DFT_COMMENT_LEN 16384
#endif
/*****************************************************************************/
char dfterrmsg[64];
/*****************************************************************************/
/** Definitions for file format (type) */
#define DFT_FORMAT_UNKNOWN  -1
#define DFT_FORMAT_PLAIN     0
#define DFT_FORMAT_STANDARD  1
#define DFT_FORMAT_IFT       2
#define DFT_FORMAT_FIT       3
#define DFT_FORMAT_NCI       4
#define DFT_FORMAT_PMOD      5
#define DFT_FORMAT_CSV_INT   6
#define DFT_FORMAT_CSV_UK    7
#define DFT_FORMAT_CPT       8
#define DFT_FORMAT_IDWC      9
#define DFT_FORMAT_IF        10
#define DFT_FORMAT_XML       11
#define DFT_FORMAT_HTML      12
#define DFT_FORMAT_XELERIS   13
/** Definitions for (frame) time type */
#define DFT_TIME_MIDDLE      0
#define DFT_TIME_START       1
#define DFT_TIME_END         2
#define DFT_TIME_STARTEND    3
/** Definitions for Decay correction */
#define DFT_DECAY_UNKNOWN      0
#define DFT_DECAY_CORRECTED    1
#define DFT_DECAY_NOTCORRECTED 2
/*****************************************************************************/
/*
 *  Data structure definitions
 */

/** Definitions for one curve */
typedef struct {
  /* Name of curve */
  /** Name of region, including hemisphere, plane etc;
      this will replace the voiname, hemisphere and place. */
  char          name[MAX_REGIONNAME_LEN+1];
  /** Name of region */
  char          voiname[MAX_REGIONSUBNAME_LEN+1];
  /** dx/sin/avg */
  char          hemisphere[MAX_REGIONSUBNAME_LEN+1];
  /** Image plane or other description */
  char          place[MAX_REGIONSUBNAME_LEN+1];
  /** Volume of region (mm x mm x mm by default) */
  double        size;
  /* Pointer to curve data and two modified curves */
  /** Pointer to original TAC */
  double       *y;
  /** Pointer to 1st modified TAC (for user) */
  double       *y2;
  /** Pointer to 2nd modified TAC (for user) */
  double       *y3;
  /** Temporary switches for outside procedures */
  char          sw, sw2, sw3;
  } Voi;

/* Definitions for a set of curves */
typedef struct {
  /* Number of data frames (points), and number of planes (curves) */
  /** Nr of samples (frames) in each TAC */
  int           frameNr;
  /** Nr of regional TACs */
  int           voiNr;
  /** Name of study (study number) */
  char          studynr[MAX_STUDYNR_LEN+1];
  /* Units */
  /** Unit of y values */
  char          unit[MAX_UNITS_LEN+1];
  /** Unit of x values: TUNIT_UNKNOWN, TUNIT_SEC, TUNIT_MIN, ... */
  int           timeunit;
  /* Study information */
  /** Name of radiopharmaceutical */
  char          radiopharmaceutical[32];
  /** Isotope */
  char          isotope[7];
  /** Decay correction: DFT_DECAY_UNKNOWN, DFT_DECAY_CORRECTED,
   *                    DFT_DECAY_NOTCORRECTED */
  char          decayCorrected;
  /** Scan start date and time: YYYY-MM-DD hh:mm:ss */
  char          scanStartTime[20];
  /** Tracer injection date and time: YYYY-MM-DD hh:mm:ss */
  char          injectionTime[20];
  /* Specified frame time */
  /** Available frame times: DFT_TIME_MIDDLE, DFT_TIME_START, DFT_TIME_END,
   *                         DFT_TIME_STARTEND */
  int           timetype;
  /* Pointers to time values */
  /** Middle frame time */
  double       *x;
  /** Frame start time  */
  double       *x1;
  /** Frame end time    */
  double       *x2;
  /** Pointers to curves */
  Voi          *voi;
  /** Pointer to weight factors */
  double       *w;
  /** Variable indicating whether weights are present (0 or 1) */
  int           isweight;
  /** String for comments */
  char          comments[_DFT_COMMENT_LEN];
  /* Internal variables for DFT procedures */
  /** Internal variable: Size of allocated memory (doubles) */
  int           _dataSize;
  /** Internal variable: Pointer to memory */
  double       *_data;
  /** Internal variable: Number of allocated curves (VOIs)*/
  int           _voidataNr;
  /** Internal variable: 0=plain datafile, 1=standard DFT, ...;
   *                     use defines DFT_FORMAT_X */
  int           _type;
  } DFT;

/*****************************************************************************/
extern void dftInit(DFT *data);
extern void dftEmpty(DFT *data);
extern int dftSetmem(DFT *data, int frameNr, int voiNr);
extern int dftAddmem(DFT *data, int voiNr);
extern int dftAdd(DFT *data1, DFT *data2, int voi);
extern int dftSelect(DFT *data, char *name);
extern int dftSelectRegions(DFT *dft, char *region_name, int reset);
extern int dftSelectBestReference(DFT *dft);
extern void dftFrametimes(DFT *data);
extern int dftOverflow(DFT *data);
extern int dftCopyvoi(DFT *data, int from, int to);
extern int dftMovevoi(DFT *dft, int from, int to);
extern int dftDelete(DFT *dft, int voi);
extern int dftCopymainhdr(DFT *dft1, DFT *dft2);
extern int dftCopymainhdr2(DFT *dft1, DFT *dft2, int ow);
extern int dftCopyvoihdr(DFT *dft1, int from, DFT *dft2, int to);
extern int dftdup(DFT *dft1, DFT *dft2);
extern int dftAllocateWithHeader(DFT *dft, int frameNr, int voiNr, DFT *dft_from);
extern int dftAddnullframe(DFT *data);
extern int dftSort(DFT *data);
extern int dftSortPlane(DFT *data);
extern int dft_nr_of_NA(DFT *dft);
extern int dftNAfill(DFT *dft);
extern int dftMinMax(DFT *dft, double *minx, double *maxx,
  double *miny, double *maxy);
extern int dftMinMaxTAC(DFT *dft, int tacindex, double *minx, double *maxx,
  double *miny, double *maxy, int *mini, int *maxi, int *mins, int *maxs);
extern int dftMaxY(DFT *dft, double t1, double t2, double *miny, double *maxy);
extern double dft_kBqMin(DFT *data);
extern double dft_kBqMax(DFT *data);
extern int dftSortByFrame(DFT *dft);
extern int dftDeleteFrameOverlap(DFT *dft);
extern int dftDeleteFrameOverlap_old(DFT *dft);
extern int dftRemoveTimeRange(DFT *dft, double startT, double endT);
extern void dftSetComments(DFT *dft);
extern int dftFillInitialGap(DFT *dft);
extern int dftAddSpaceForFrames(DFT *dft, int nr_to_add);
extern void dftRNameSimplify(DFT *dft, int hemisphere, int place);
extern int dftMeanTAC(DFT *dft, DFT *mean);
/*****************************************************************************/
/* Deprecated functions. Please don't use these anymore */
#define initDFT dftInit
#define emptyDFT dftEmpty
#define setmemDFT dftSetmem
#define addmemDFT dftAddmem
#define addDFT dftAdd
#define selectDFT dftSelect
#define frametimesDFT dftFrametimes
#define overflowDFT dftOverflow
#define copyvoiDFT dftCopyvoi
#define copymainhdrDFT dftCopymainhdr
#define copyvoihdrDFT dftCopyvoihdr
#define addnullframeDFT dftAddnullframe
#define sortDFT dftSort
#define na_fillDFT dftNAfill
/*****************************************************************************/
#endif

