/******************************************************************************
  Copyright (c)  2007-2012 by Turku PET Centre

  dftio.h - See dftio.c

  Date:
  2007-02-10 Vesa Oikonen
    Separated from dft.h.
  2007-08-12 VO
    Added define for BACKUP_EXTENSION.
  2008-10-10 VO
    Added global variable DFT_NR_OF_DECIMALS.
  2012-02-28 VO
    Added function dftFormat().
    dft_fill_hdr_from_title_line() replaced by dftGetPmodTitle().


******************************************************************************/
#ifndef _DFTIO_H
#define _DFTIO_H
/*****************************************************************************/
#include "studynr.h"
#include "ift.h"
/*****************************************************************************/
#include "dft.h"
/*****************************************************************************/
/* DFT FILE FORMAT ID */
#ifndef DFT_VER
#define DFT_VER "DFT1"
#endif
/* MAX TOTAL LENGTH OF DFT COMMENTS */
#ifndef _DFT_COMMENT_LEN
#define _DFT_COMMENT_LEN 16384
#endif
/* Backup file extension */
#ifndef BACKUP_EXTENSION
#define BACKUP_EXTENSION ".bak"
#endif 
/* Nr of decimals for concentration values */
extern int DFT_NR_OF_DECIMALS;
/*****************************************************************************/
extern int dftRead(char *filename, DFT *data);
extern int dftWrite(DFT *data, char *filename);
extern void dftPrint(DFT *data);
extern int dftFormat(char *fname);
extern int dftType(FILE *fp);
extern int dftWriteHTML(DFT *dft, char *fname, int orientation);
extern int dftWriteXHTML11_doctype(FILE *fp);
extern int dftWriteXHTML11_head(FILE *fp, char *author_name);
extern int dft_fill_hdr_from_IFT(DFT *dft, IFT *ift);
extern int dftGetPmodTitle(DFT *dft, char *title_line);
/*****************************************************************************/
#endif
