/******************************************************************************

  dftunit.h    (c) 2007 by Turku PET Centre

  See dftunit.c

  2007-08-13 Vesa Oikonen

******************************************************************************/
#ifndef _DFTUNIT_H
#define _DFTUNIT_H
/*****************************************************************************/
#include "petunits.h"
/*****************************************************************************/
#include "dft.h"
/*****************************************************************************/
extern void dftUnitToDFT(DFT *dft, int dunit);
extern int dftUnitConversion(DFT *dft, int dunit);
/*****************************************************************************/
extern int dftTimeunitToDFT(DFT *dft, const char *timeunit);
extern int dftTimeunitConversion(DFT *dft, int tunit);
extern void dftMin2sec(DFT *data);
extern void dftSec2min(DFT *data);
/*****************************************************************************/
/* Deprecated functions. Please don't use these anymore */
#define dftUnitId petCunitId
#define dftUnit petCunit
#define dftTimeunitId petTunitId
#define dftTimeunit petTunit
/*****************************************************************************/
/* DFTUNITs are deprecated unit definitions. Please don't use these anymore */
#define DFTUNIT_UNKNOWN CUNIT_UNKNOWN
#define DFTUNIT_CPS CUNIT_CPS
#define DFTUNIT_COUNTS CUNIT_COUNTS
#define DFTUNIT_KBQ_PER_ML CUNIT_KBQ_PER_ML
#define DFTUNIT_SEC_KBQ_PER_ML CUNIT_SEC_KBQ_PER_ML
#define DFTUNIT_PER_SEC CUNIT_PER_SEC
#define DFTUNIT_PER_MIN CUNIT_PER_MIN
#define DFTUNIT_ML_PER_ML CUNIT_ML_PER_ML
#define DFTUNIT_ML_PER_DL CUNIT_ML_PER_DL
#define DFTUNIT_ML_PER_ML_PER_MIN CUNIT_ML_PER_ML_PER_MIN
#define DFTUNIT_ML_PER_DL_PER_MIN CUNIT_ML_PER_DL_PER_MIN
#define DFTUNIT_UNITLESS CUNIT_UNITLESS
#define DFTUNIT_NCI_PER_ML CUNIT_NCI_PER_ML
#define DFTUNIT_MBQ_PER_ML CUNIT_MBQ_PER_ML
#define DFTUNIT_BQ_PER_ML CUNIT_BQ_PER_ML
#define DFTUNIT_UCI_PER_ML CUNIT_UCI_PER_ML
#define DFTUNIT_UMOL_PER_MIN_PER_100G CUNIT_UMOL_PER_MIN_PER_100G
#define DFTUNIT_MG_PER_MIN_PER_100G CUNIT_MG_PER_MIN_PER_100G
/* DFTTIMEs are deprecated unit definitions. Please don't use these anymore */
#define DFTTIME_UNKNOWN TUNIT_UNKNOWN
#define DFTTIME_SEC TUNIT_SEC
#define DFTTIME_MIN TUNIT_MIN
#define DFTTIME_UM TUNIT_UM
#define DFTTIME_MM TUNIT_MM
/*****************************************************************************/
#endif
