/******************************************************************************
  Copyright (c)  2001-2013 by Turku PET Centre

  mathfunc.h

  Version:
  2001-10-04 Vesa Oikonen
  2003-02-19 VO
  2003-08-14 VO
  2004-09-20 VO
    Changed the comments to doxygen style.
  2005-10-15 VO
    Changed function names.
    Field "name" added to Voi struct.
  2007-08-12 VO
    Added define for BACKUP_EXTENSION.  
  2007-08-13 VO
    Units length in DFT struct is defined as MAX_UNITS_LEN+1 (previously 13).
  2007-09-13 VO
    Added field fitmethod in FIT struct.
  2008-07-11 VO
    Previous comment was wrong, fitmethod was never added in FIT struct.
    FIT struct filename size changed from 1024 to FILENAME_MAX.
  2009-03-06 VO
    Additional comments.
  2009-04-15 VO
    MAX_FITPARAMS was changed from 20 to 50.
  2011-01-20 VO
    Added enum mathfuncs.
  2012-08-16 VO
    MAX_FITPARAMS was changed from 50 to 100.
  2012-09-28 VO
    FIT struct applies defined value MAX_REGIONSUBNAME_LEN.
  2012-12-03 VO
    Added studynr to FIT struct.
  2013-12-13 VO
    Added MF_EHILL2_PAR=848 and MF_EHILL2_MET=849.


******************************************************************************/
#ifndef _MATHFUNC_H
#define _MATHFUNC_H
/*****************************************************************************/
#include <time.h>
/*****************************************************************************/
#include "studynr.h"
#include "rname.h"
#include "petunits.h"
/*****************************************************************************/
#define FIT_VER "FIT1"
/*****************************************************************************/
/* Max nr of parameters */
#ifndef MAX_FITPARAMS
#define MAX_FITPARAMS 100
#endif
/*****************************************************************************/
/* Backup file extension */
#ifndef BACKUP_EXTENSION
#define BACKUP_EXTENSION ".bak"
#endif 
/*****************************************************************************/
int MATHFUNC_TEST;
/*****************************************************************************/
char fiterrmsg[64];
/*****************************************************************************/
enum mathfuncs {
  MF_LEVEL=100, MF_LINE, MF_POL2, MF_POL3, MF_POL4, MF_POL5, MF_POL6, MF_POL7,
  MF_POL8, MF_POL9,
  MF_RATF11=211, MF_RATF21=221, MF_RATF22=222, MF_RATF32=232, MF_RATF33=233,
  MF_EXP1=301, MF_EXP2, MF_EXP3, MF_EXP4, MF_EXP5,
  MF_LUNDQVIST=321, MF_LUNDQVIST2, MF_LUNDQVIST3,
  MF_EXPBOLUSINF=331, MF_EXPBOLUSINF_RW=332, MF_MF_EXPBOLUSINF_AZ=334,
  MF_PK11195=351,
  MF_HILL=841, MF_1MHILL=842, MF_1MHILL_ADE=843, MF_HILL_B=844, MF_AMHILL=845,
  MF_EHILL_PAR=846, MF_EHILL_MET=847,
  MF_EHILL2_PAR=848, MF_EHILL2_MET=849,
  MF_MAMEDE=851, MF_1MMAMEDE,
  MF_MAYER_PAR=861, MF_MAYER_MET, MF_EMAYER_PAR, MF_EMAYER_MET,
  MF_HILL3M_PAR=871, MF_HILL3M_M1, MF_HILL3M_M2, MF_HILL3M_M3, 
  MF_PF3M_PAR=881, MF_PF3M_M1, MF_PF3M_M2, MF_PF3M_M3, 
  MF_RATF33D=1232,
  MF_FENGM2=1313, MF_FENGM2E=1314,
  MF_GAMMAV=1401, MF_GAMMAVB=1402,
  MF_WEIBULLCDF_D=1421, MF_WEIBULLCDF_DD=1423,
  MF_HILL_D=1801, MF_HILL_DD=1811, MF_HILL_SDD=1821,
  MF_IMGPROFILE=2111,
  MF_GRAHAM_INP=9501, MF_GRAHAM_EINP, MF_GRAHAM_INPM,
  MF_HUANG_MET=9601, MF_CARSON_EMET, MF_NEW_MET,
  MF_MLMCM=9701,
};
/*****************************************************************************/
/*
 *  Data structure definitions
 */

/** Definitions for one curve */
typedef struct {
  /** Name of the curve */
  /** Name of region, including hemispehere, plane etc;
      this will replace the voiname, hemisphere and place. */
  char      name[MAX_REGIONNAME_LEN+1];
  /** Name of region */
  char      voiname[MAX_REGIONSUBNAME_LEN+1];
  /** dx/sin/avg */
  char      hemisphere[MAX_REGIONSUBNAME_LEN+1];
  /** Image plane or other description */
  char      place[MAX_REGIONSUBNAME_LEN+1];
  /** Number (type) of function */
  int       type;
  /** The number of parameters */
  int       parNr;
  /** Fit start time */
  double    start;
  /** Fit end time */
  double    end;
  /** Number of data points in the fit */
  int       dataNr;
  /** Fitted parameters */
  double    p[MAX_FITPARAMS];
  /** (weighted) sum-of-squares */
  double    wss;
  /** Temporary switches for outside procedures */
  char      sw, sw2, sw3;
} FitVOI;

/** Definitions for a set of curves */
typedef struct {
  /** Number of regions */
  int       voiNr;
  /** Name of original datafile */
  char      datafile[FILENAME_MAX];
  /** Name of study (study number) */
  char      studynr[MAX_STUDYNR_LEN+1];
  /** Unit of concentration */
  char      unit[MAX_UNITS_LEN+1];
  /** Time unit: TUNIT_UNKNOWN, TUNIT_SEC, TUNIT_MIN, ... */
  int       timeunit;
  /** Pointers to regional curves */
  FitVOI   *voi;
  /** Fit date and time */
  time_t    time;
  /** Program name */
  char      program[1024];
  /** Internal variables: Number of allocated curves (VOIs) */
  int      _voidataNr; /*  */
} FIT;
/*****************************************************************************/
extern void fitEmpty(FIT *fit);
extern void fitInit(FIT *fit);
extern int fitSetmem(FIT *fit, int voiNr);
extern void fitPrint(FIT *fit);
extern int fitWrite(FIT *fit, char *filename);
extern int fitRead(char *filename, FIT *fit);
extern int fitEval(FitVOI *r, double x, double *y);
extern int fitEvaltac(FitVOI *r, double *x, double *y, int dataNr);
extern int fitFunctionname(int type, char *str);
extern int fitFunctionformat(int type, char *str);
extern int fitIntegralEval(FitVOI *r, double x, double *yi);
extern int fitIntegralEvaltac(FitVOI *r, double *x, double *yi, int dataNr);
extern int fitDerivEval(FitVOI *r, double x, double *yd);
extern int fitDerivEvaltac(FitVOI *r, double *x, double *yd, int dataNr);
/*****************************************************************************/
/* Deprecated functions. Please don't use these anymore */
#define emptyFIT fitEmpty
#define initFIT fitInit
#define setmemFIT fitSetmem
#define printFIT fitPrint
#define writeFIT fitWrite
#define readFIT fitRead
#define evalFIT fitEval
#define evaltacFIT fitEvaltac
#define functionnameFIT fitFunctionname
#define functionformatFIT fitFunctionformat
#define ievalFIT fitIntegralEval
#define ievaltacFIT fitIntegralEvaltac
#define devalFIT fitDerivEval
#define devaltacFIT fitDerivEvaltac
/*****************************************************************************/
#endif

