/******************************************************************************
  Copyright (c) 2002-2012 Turku PET Centre

  result.h

  Version:
  2002-08-14 Vesa Oikonen
  2002-10-10 VO
  2002-11-13 VO
  2003-01-18 VO
    Added CL's and SD's for each result parameter.
    MAX_RESPARAMS changed from 20 to 30.
  2003-12-02 VO
    Filename lengths defined with FILENAME_MAX.
    Added fields for tissue density, lumped constant, and plasma concentration.
  2004-01-26 VO
    Added field for beta.
  2004-07-12 VO
    Added field for Vb.
    Doxygen style comments.
  2004-07-26 VO
    Comment style changes.
  2004-08-17 VO
    Added sw2.
  2004-08-23 VO
    MAX_STUDYNR_LEN applied.
  2006-06-03 VO
    Field "name" added to ResVOI struct.
    Added text field for units of parameters.
  2006-07-31 VO
    Added function resParameterPrintType().
  2007-01-12 VO
    See result.c.
  2007-08-12 VO
    Added define for BACKUP_EXTENSION.  
  2007-09-13 VO
    Added fields datanr and fitmethod in RES struct.
    Added function resSelectRegions().
  2009-12-29 VO
    Added functions for comparing two RES structs.
  2010-06-05 VO
    Added function resWriteHTML_table().
  2010-12-12 VO
    Additional fields in RES struct.
  2012-08-16 VO
    MAX_RESPARAMS changed from 30 to 100.
  2012-09-27 VO
    Added function resRNameSubfieldExists().
  2012-09-28 VO
    RES struct applies defined value MAX_REGIONSUBNAME_LEN.
  2012-12-03 VO
    Added fA and E to RES struct.


******************************************************************************/
#ifndef _RESULT_H
#define _RESULT_H
/*****************************************************************************/
#include <time.h>
/*****************************************************************************/
#include "studynr.h"
#include "rname.h"
/*****************************************************************************/
/* Max nr of parameters */
#ifndef MAX_RESPARAMS
#define MAX_RESPARAMS 100
#endif
/* Max length of parameter names and units */
#ifndef MAX_RESPARNAME_LEN
#define MAX_RESPARNAME_LEN 15
#endif
/*****************************************************************************/
/* Backup file extension */
#ifndef BACKUP_EXTENSION
#define BACKUP_EXTENSION ".bak"
#endif 
/*****************************************************************************/
int RESULT_TEST;
/*****************************************************************************/
char reserrmsg[64];
/*****************************************************************************/
/*
 *  Data structure definitions
 */
/* Definitions for one region */
typedef struct {
  /* Name of the curve */
  /** Name of region, including hemispehere, plane etc;
      this will some day replace the voiname, hemisphere and place. */
  char      name[MAX_REGIONNAME_LEN+1];
  /** Name of region */
  char      voiname[MAX_REGIONSUBNAME_LEN+1];
  /** dx/sin/avg */
  char      hemisphere[MAX_REGIONSUBNAME_LEN+1];
  /** Image plane or other description */
  char      place[MAX_REGIONSUBNAME_LEN+1];
  /* Parameters and their SD's and CL's*/
  /** Array of result values */
  double    parameter[MAX_RESPARAMS];
  /** Array of result SD's   */
  double    sd[MAX_RESPARAMS];
  /** Lower 95% confidence interval */
  double    cl1[MAX_RESPARAMS];
  /** Upper 95% confidence interval */
  double    cl2[MAX_RESPARAMS];
  /** Temporary switches for user */
  int       sw, sw2;
} ResVOI;

/* Definitions for a set of regions */
typedef struct {
  /** Program that produced the results */
  char      program[1024];
  /** Calculation date and time */
  time_t    time;
  /** Number of regions */
  int       voiNr;
  /** Number of parameters, <=MAX_RESPARAMS */
  int       parNr;
  /** Name of study (study number) */
  char      studynr[MAX_STUDYNR_LEN+1];
  /* Names of original datafiles */
  /** Name of original tissue datafile */
  char      datafile[FILENAME_MAX];
  /** Name of original ref datafile */
  char      reffile[FILENAME_MAX];
  /** Name of original plasmafile */
  char      plasmafile[FILENAME_MAX];
  /** Name of second original plasmafile */
  char      plasmafile2[FILENAME_MAX];
  /** Name of original bloodfile */
  char      bloodfile[FILENAME_MAX];
  /** Name of reference region */
  char      refroi[64];
  /** Free field describing fit time range */
  char      datarange[128];
  /** Number of data values used in modelling */
  int       datanr;
  /** Free text field describing fit method */
  char      fitmethod[128];
  /* Parameters affecting the results */
  /** 0=Data was not weighted, 1=Data was weighted, -1=not known */
  int       isweight;
  /** Tissue density (g/ml) */
  double    density;
  /** Lumped Constant (unitless) */
  double    lc;
  /** Beta */
  double    beta;
  /** Plasma concentration of native substrate, e.g. glucose */
  double    concentration;
  /** Vb percentage */
  double    Vb;
  /** fA percentage (arterial volume of Vb) */
  double    fA;
  /** Extraction fraction */
  double    E;
  /** List of parameter names */
  char      parname[MAX_RESPARAMS][MAX_RESPARNAME_LEN+1];
  /** List of parameter units */
  char      parunit[MAX_RESPARAMS][MAX_RESPARNAME_LEN+1];
  /** Parameter names separated by space(s); deprecated */
  char      titleline[1024];
  /** Parameter units separated by space(s); deprecated */
  char      unitline[1024];
  /** Pointers to regional curves */
  ResVOI   *voi;
  /* Internal variables for RESULT procedures */
  /** Internal variable: Number of allocated curves (VOIs); do not change */
  int      _voidataNr;
} RES;
/*****************************************************************************/
extern void resEmpty(RES *res);
extern void resInit(RES *res);
extern int resSetmem(RES *res, int voiNr);
extern void resFixParnames(RES *res);
extern void resPrint(RES *res);
extern int resRead(char *filename, RES *res);
extern int resWrite(RES *res, char *filename);
extern int resWriteHTML(RES *res, char *fname);
extern int resFName2study(char *fname, char *studyNumber);
extern int resMedian(double *data, int nr,
  double *median, double *min, double *max);
extern int resMean(double *data, int nr, double *mean, double *sd);
extern void resSortByName(RES *res);
extern int resCopyMHeader(RES *res1, RES *res2);
extern int resDelete(RES *res, int voi);
extern int resSelect(RES *data, char *name);
extern int resSelectRegions(RES *res, char *region_name, int reset);
extern int resParameterPrintType(RES *res, int parIndex);
extern int resWriteXHTML11_doctype(FILE *fp);
extern int resWriteXHTML11_head(FILE *fp, char *author_name);
extern int resWriteHTML_table(RES *res, FILE *fp);
extern int resIsDuplicateNames(RES *res);
extern int resMatchHeader(RES *res1, RES *res2);
extern int resMatchRegions(RES *res1, RES *res2);
extern int resMatchParameternames(RES *res1, RES *res2);
extern int resMatchParameters(RES *res1, RES *res2,
  int test_par, double test_limit, int test_sd);
extern int resMatchParametersAbs(RES *res1, RES *res2,
  int test_par, double test_limit, int test_sd);
extern int resRNameSubfieldExists(RES *res);
/*****************************************************************************/
#endif

