/******************************************************************************

  libtpccurveiov.c  (c) 2004-2014 Turku PET Centre

  This file contains function for printing the date and time when this library
  is compiled.

  See the versions and history below.


******************************************************************************/

/** Library name. */
#define LIB_NAME "libtpccurveio"

/** Library version. */
#define LIB_VERSION "2.4.10"

/** Copyright. */
#define COPYRIGHT "(c) 2004-2014 by Turku PET Centre, University of Turku"

/*****************************************************************************/
#include <stdio.h>
#include "libtpccurveiov.h"
/*****************************************************************************/

/*****************************************************************************/
/**
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpccurveio_print_readme(FILE *fp){
  fputs(
  "\n"
  LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
  "\n"
  "Build "__DATE__" "__TIME__"\n"
  "\n"
  "\n"
  "PET time-activity curve IO library\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "Library is distributed under the GNU Lesser General Public Licence\n"
  "http://www.turkupetcentre.net/software/lgpl-license.html\n"
  "More information on open source licences: http://www.opensource.org\n"
  "\n"
  "Contents\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "include/         - Includes all the header files for the .c files\n"
  "Makefile         - The makefile\n"
  "\n"
  "** .c files **\n"
  "\n"
  "cpt.c            - Functions for reading and writing CPT files.\n"
  "csv.c            - Functions for reading and writing CSV files.\n"
  "dft.c            - Working with DFT (TAC) data structure.\n"
  "dftdecay.c       - Decay correction for TAC data.\n"
  "dftio.c          - Reading and writing DFT (TAC) files.\n"
  "dftres.c         - Setting up RES (results) based on DFT (TAC data).\n"
  "dftunit.c        - Calibration and time units processing for DFT files.\n"
  "idwc.c           - Functions for reading and writing IDWC TAC files.\n"
  "if.c             - Functions for reading and writing IF TAC files.\n"
  "mathfunc.c       - Functions for FIT files and mathematical functions.\n"
  "ncifile.c        - Support previous TAC format (*.roi.kbq/*.roi.nci).\n"
  "petunits.c       - Calibration and time units definitions for PET data.\n"
  "result.c         - Reading and writing result files.\n"
  "libtpccurveiov.c - Functions for printing the library information.\n"
  "libtpccurveio.c  - Program for printing the library information, \n"
  "                   and for testing the library functions.\n"
  "xeleris.c        - Functions for reading and writing GEMS Xeleris TACs.\n"
  "Using the library\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "The program that uses the library should include the .h file it needs.\n"
  "Example:        \\#include <curveio.h>\n"
  "\n"
  "                gcc myprog.c -ltpccurveio -lm\n"
  "\n"
  "\n",
  fp);
  fflush(fp);
}

/**
    Print the library History to specified FILE pointer,
    use stdout for screen.
*/
void libtpccurveio_print_history(FILE *fp)
{
  fputs(
  "2004-11-07 Vesa Oikonen\n"
  "2005-01-20 Calle Laakkonen\n"
  "2005-04-26 Jarkko Johansson\n"
  "  Functions libtpccurveio_print_readme(), libtpccurveio_print_history(),\n"
  "  libtpccurveio_print_dreadme() and libtpccurveio_print_dhistory()\n"
  "  are used for getting the Readme and History messages for libtpccurveio,\n"
  "  with and without Doxygen style tags. Remember to update the\n"
  "  functions to get correct Readme and History messages!\n"
  "  Function libtpccurveio_print_build(), is used for getting the build\n"
  "  information.\n"
  "  Merged with libcpt.\n"
  "2005-06-17 Kaisa Sederholm\n"
  "  New version of dft.c.\n"
  "2005-10-30 Vesa Oikonen\n"
  "  New version of mathfunc.c, result.c, and dft.c.\n"
  "2005-11-30 Vesa Oikonen\n"
  "  Added support to Imanet London TAC files (idwc.c and if.c).\n"
  "2005-12-05 KS\n"
  "  Added warning if the function dftWrite is writing the file \n"
  "  with a name that allready exists.\n"
  "2006-01-31 VO\n"
  "  New version of mathfunc.c.\n"
  "2006-05-15 VO\n"
  "  New version of dft.c.\n"
  "2006-06-03 VO\n"
  "  Added support for Hill function with background (mathfunc.c).\n"
  "  Added fields in result data structure (result.h and result.c).\n"
  "  Field names in result data structure are case-insensitive.\n"
  "  Field names in fit data structure are case-insensitive.\n"
  "2006-07-12 VO\n"
  "  New version of result.c.\n"
  "  New functions in dft.c, dft.h changed accordingly.\n"
  "2006-07-31 VO\n"
  "  New version of result.c, result.h changed accordingly.\n"
  "2006-12-01 VO\n"
  "  Corrected a bug: existing backup files were not overwritten.\n"
  "2007-01-15 VO\n"
  "  New functions in dft.c and result.c."
  "  Additions in dft.h and result.h, accordingly.\n"
  "  Corrected a bug: existing result backup files were not overwritten.\n"
  "2007-01-26 VO\n"
  "  Corrected a bug with XHTML tables of plain DFT data.\n"
  "2007-02-10 VO\n"
  "  New functions for processing calibration and time units.\n"
  "  Programs that work with time unit MUST be updated to use\n"
  "  DFTTIME_MIN, DFTTIME_SEC or DFTTIME_UNKNOWN.\n"
  "2007-04-13 VO\n"
  "  New function for adding extra information in comments.\n"
  "2007-04-20 VO\n"
  "  Corrected bugs in reading and writing fit files.\n"
  "  Added support for Hill function which does not start from 1.0.\n"
  "2007-04-24 VO\n"
  "  Corrected bug: crashed when writing DFT file was not successful.\n"
  "2007-08-12 VO\n"
  "  Change in DFT writing defaults.\n"
  "  New functions for setting up results based on DFT data.\n"
  "  Change in function that corrects DFT frame overlapping.\n"
  "  Backup file extension can be changed by defining BACKUP_EXTENSION\n"
  "  before including any TPC libraries; remember to include the '.'.\n"
  , fp);
  fputs(
  "2007-09-13 VO\n"
  "  Added fields datanr and fitmethod in RES struct.\n"
  "  Added function resSelectRegions().\n"
  "2008-03-20 VO\n"
  "  Bug correction in writing units.\n"
  "2008-05-15 VO\n"
  "  Bug correction in reading result files.\n"
  "2008-07-14 VO\n"
  "  Added functions dftSelectBestReference() and dftAllocateWithHeader().\n"
  "2008-08-04 VO\n"
  "  Added CSV read functions.\n"
  "2008-08-26 VO\n"
  "  Added support for Weibull cdf.\n"
  "2008-09-04 VO\n"
  "  Added support for Weibull cdf plus its derivative.\n"
  "2008-10-10 VO\n"
  "  DFT data can be saved with higher precision by changing\n"
  "  DFT_NR_OF_DECIMALS.\n"
  "2009-01-09 VO\n"
  "  CPT and *.roi.kbq formats are read with weights initiated to 1.\n"
  "2009-02-26 VO\n"
  "  Calibration units in CPT files are better identified.\n"
  "2009-03-06 VO\n"
  "  Function 843 was changed (mathfunc.c).\n"
  "  Added xelRead() in new xeleris.c.\n"
  "  Added tsvRead() in new tsv.c.\n"
  "2009-04-15 VO\n"
  "  MAX_FITPARAMS was changed from 20 to 50 in mathfunc.h.\n"
  "2009-05-12 VO\n"
  "  Function 332 was added in mathfunc.c.\n"
  "2009-06-09 VO\n"
  "  Added dftFillInitialGap() in dft.c.\n"
  "2009-06-21 VO\n"
  "  Function dftAddmem() rewritten in dft.c.\n"
  "2009-07-28 VO\n"
  "  Added fitres.c and fitres.h, with functions fitToResult() and\n"
  "  fit_allocate_with_dft().\n"
  "2009-07-30 VO\n"
  "  Tiny change reading study number in dftio.c.\n"
  "2009-08-10 VO\n"
  "  Function 334 was added in mathfunc.c.\n"
  "2009-08-19 VO\n"
  "  Function 1321 was added in mathfunc.c.\n"
  , fp);
  fputs(
  "2009-12-29 VO\n"
  "  Fixed a bug in reading time units in DFT files.\n"
  "  Added functions for comparing two RES structs.\n"
  "2010-01-19 VO\n"
  "  Change in function 332 parameters.\n"
  "2010-03-30 VO\n"
  "  DFT frame middle or start and end times are filled also when\n"
  "  time units are unknown.\n"
  "2010-04-12 VO\n"
  "  Added function in dft.c\n"
  "  petunits.c and petunits.h moved into libtpcmisc.\n"
  "2010-04-26 VO\n"
  "  dftRead() can read Inveon PET/CT CSV files.\n"
  "2010-06-05 VO\n"
  "  Added function resWriteHTML_table().\n"
  "2010-08-16 VO\n"
  "  Added functions 861 and 862 for parent and metabolite fractions.\n"
  "2010-09-17 VO\n"
  "  Added functions 846, 847, 863 and 864 for parent and metab fractions.\n"
  "2010-10-07 VO\n"
  "  Addition in fitToResult().\n"
  "2010-10-08 VO\n"
  "  Correction in dftFrameTimes().\n"
  "2010-10-12 VO\n"
  "  Added function dftMinMaxTAC in dft.c.\n"
  "2010-10-30 VO\n"
  "  NA definition replaced by NaN (isnan(f) and f=nan("") ).\n"
  "  2010-11-09 VO\n"
  "  Bug fix in dftAddnullframe().\n"
  "2010-11-15 VO\n"
  "  dftRead() reads additional file type containing one title\n"
  "  which does not start with comment mark.\n"
  "2010-12-14 1.10.0 VO\n"
  "  Additional field plasmafile2 in RES struct.\n"
  "  Fields titleline and unitline is RES struct are depracated\n"
  "  (but supported for now) and substituted by array fields\n"
  "  parname[] and parunit[].\n"
  "  Bug fix in resMatchParametersAbs() and resMatchParameters().\n"
  "2011-01-13 1.10.1 VO\n"
  "  Bug fix in resFixParnames().\n"
  "2011-01-20 1.10.2 VO\n"
  "  Small changes and additions in mathfunc.c.\n"
  "2011-01-26 1.10.3 VO\n"
  "  Added function dftMaxY in dft.c.\n"
  , fp);
  fputs(
  "2011-01-28 1.10.4 VO\n"
  "  Bug fix in dftMaxY().\n"
  "  Change in resMatchParameters().\n"
  "2011-02-16 1.10.5 VO\n"
  "  csv2dft() led to unhandled exception in case of non-supported\n"
  "  csv file; this is now fixed.\n"
  "2011-02-17 1.10.6 VO\n"
  "  csv2dft() handels a second type of Inveon data.\n"
  "2011-04-27 1.10.7 VO\n"
  "  dftRead() divides long region name into subfields.\n"
  "2011-06-21 1.10.8 VO\n"
  "  Small changes and bug fix in result file reading and writing.\n"
  "2011-06-22 1.10.9 VO\n"
  "  Further change in resFixParnames().\n"
  "2011-07-01 1.10.10 VO\n"
  "  dftUnitConversion() supports additional conversions.\n"
  "2011-08-10 1.10.11 VO\n"
  "  Fixed integrals for functions 1313 and 1314 in mathfunc.c.\n"
  "2011-09-09 2.0.0 VO\n"
  "  Changes to compile, install and distribute in 64-bit systems.\n"
  "2011-12-30 2.0.1 VO\n"
  "  Additional functions and fixed descriptions in mathfunc.c.\n"
  "2012-02-24 2.0.2 VO\n"
  "  Tiny changes in unit identification in csv.c.\n"
  "2012-02-28 2.0.3 VO\n"
  "  Added defines for DFT format field contents into dft.h.\n"
  "2012-02-29 2.1.0 VO\n"
  "  Added function dftFormat().\n"
  "  dft_fill_hdr_from_title_line() replaced by dftGetPmodTitle().\n"
  "  Changes in format identification in dftRead().\n"
  "  dftRead() and dftWrite() support PMOD format.\n"
  "2012-03-05 2.1.1 VO\n"
  "  Better data validation in dftRead().\n"
  "2012-03-07 2.1.2 VO\n"
  "  Bug fix in fitRead().\n"
  "2012-03-15 2.1.3 VO\n"
  "  Change in fitEval() in function 844.\n"
  "  Bug fix in dftRead() with plain format.\n"
  "2012-04-20 2.2.0 VO\n"
  "  dftWrite() uses tab as column separator instead of spaces.\n"
  "  fitWrite() uses tab as column separator instead of spaces.\n"
  "  resWrite() uses tab as column separator instead of spaces;\n"
  "  programs that read result files must be recompiled using this\n"
  "  or later library version.\n"
  "2012-05-07 2.2.1 VO\n"
  "  Bug fix in resRead().\n"
  "2012-06-01 2.2.2 VO\n"
  "  When creating voinames, dftRead() pads zeroes only as needed.\n"
  "2012-06-06 2.2.3 VO\n"
  "  Another bug fix in resRead().\n"
  "  Removed some code fragments that had been commented out.\n"
  "2012-06-11 2.2.4 VO\n"
  "  And another bug fix in resRead().\n"
  "2012-06-19 2.2.5 VO\n"
  "  Additional parameters for dftMinMaxTAC().\n"
  "  Tiny changes in test printing.\n"
  "2012-06-28 2.2.6 VO\n"
  "  Again bug fix in resRead().\n"
  "2012-07-06 2.2.7 VO\n"
  "  dftFrametimes() checks that frame start and end times really exist.\n"
  "2012-08-16 2.2.8 VO\n"
  "  MAX_RESPARAMS changed from 30 to 100.\n"
  "  MAX_FITPARAMS changed from 50 to 100.\n"
  "2012-09-25 2.2.9 VO\n"
  "  dftWrite() saves PMOD files in format that is compatible with new\n"
  "  PMOD versions.\n"
  , fp);
  fputs(
  "2012-09-27 2.2.10 VO\n"
  "  Change in resWriteHTML_table() in result.c.\n"
  "2012-09-28 2.3.0 VO\n"
  "  MAX_REGIONSUBNAME_LEN is used instead of hard-coded value 6(+1).\n"
  "  Added function dftRNameSimplify() in dft.c.\n"
  "  PMOD TAC files can have region names with spaces.\n"
  "2012-10-24 2.3.1 VO\n"
  "  Changed dftFormat() to try to identify TAC formats first based on\n"
  "  magic number and only then based on filename extention.\n"
  "2012-10-25 2.3.2 VO\n"
  "  Added function dftRemoveTimeRange() in dft.c.\n"
  "2012-10-30 2.3.3 VO\n"
  "  Added function dftMeanTAC() in dft.c.\n"
  "2012-11-10 2.3.4 VO\n"
  "  dftFormat() identifies CSV international and UK formats separately.\n"
  "  csv2dft() sets TAC names to defaults unless found in CSV file.\n"
  "  csv2dft() sets DFT plain format if none of TACs had a name.\n"
  "2012-11-21 2.3.5 VO\n"
  "  Change handling NaNs in dftMinMax().\n"
  "2012-12-03 2.4.0 VO\n"
  "  Additional fields in RES and FIT structs.\n"
  "2013-04-17 2.4.1 VO\n"
  "  Included libtpcmisc.h in all .c files.\n"
  "2013-05-13 2.4.2 VO\n"
  "  Small updates in resInit() and res_allocate_with_dft().\n"
  "2013-06-17 2.4.3 VO\n"
  "  dftRead() verifies that DFT files do not contain extra title fields.\n"
  "  Added function dftCopymainhdr2().\n"
  "  csvRead() can read CSV files with start and end time.\n"
  "2013-06-18 2.4.4 VO\n"
  "  Fixed a bug in dftRead().\n"
  "2013-06-24 VO\n"
  "  Function dftRead() returns specific error codes in case of format errors.\n"
  "2013-07-02 2.4.5 VO\n"
  "  Added dftdecay.c and dftdecay.h.\n"
  "  Small changes in dft.c, mathfunc.c, and result.c.\n"
  "2013-08-13 2.4.6 VO\n"
  "  Small changes in results.c.\n"
  "2013-10-07 2.4.7 VO\n"
  "  Function dftRead() can read LinkSet TAC file.\n"
  "2013-12-13 2.4.8 VO\n"
  "  Added functions 848 and 849 for parent and metab fractions.\n"
  "2014-03-05 2.4.9 VO\n"
  "  dftFormat() and dftType() accept the copyright character.\n"
  "2014-07-10 2.4.10 VO\n"
  "  dftRead() should work when the 3rd title line in DFT has (erroneously)\n"
  "  the concentration unit made up of two parts (by some Carimas versions).\n"
  "\n"
  , fp);
  fflush(fp);
}


/**
    Print the library Readme to specified FILE pointer with Doxygen tags,
    use stdout for screen.
*/
void libtpccurveio_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<pre>\n",
    LIB_NAME, LIB_VERSION, COPYRIGHT);
  libtpccurveio_print_readme(fp);
  fprintf(fp,"\n</pre> \n */\n");
}

/**
    Print the library History to specified FILE pointer with Doxygen tags,
    use stdout for screen.
*/
void libtpccurveio_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<pre>\n");
  libtpccurveio_print_history(fp);
  fprintf(fp,"\n</pre> \n */\n");
}

/**
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpccurveio_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n", LIB_NAME, LIB_VERSION, COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n", __DATE__, __TIME__);
#ifdef __STRICT_ANSI__
  fprintf(fp," (ANSI compatible build)\n");
#endif
#if defined(__FILE__) && defined(__TIMESTAMP__)
  printf(" File %s last edited on %s\n", __FILE__, __TIMESTAMP__);
#endif
#if defined(__STDC_VERSION__)
  printf(" Version of C: %ld\n", __STDC_VERSION__);
#endif
#if defined(__STDC_ISO_10646__)
  printf(" Compiler ISO/IEC 10646 specification: %ld\n", __STDC_ISO_10646__);
#endif
#if defined(__GNUC__) && defined(__VERSION__)
  printf(" GNU C version: %s\n", __VERSION__);
#endif
#if defined(__x86_64__) || defined(__LP64__) || defined(__ppc64__)
  printf(" Architecture: 64-bit\n");
#else
  printf(" Architecture: 32-bit\n");
#endif
}



/** Print the compilation date and time to specified FILE pointer  */
void libtpccurveio_printdate(FILE *fp)
{
  libtpccurveio_print_build(fp);
}

/*****************************************************************************/

/*****************************************************************************/
