/******************************************************************************
  Copyright (c) 2012,2013 by Turku PET Centre

  idi.h

  Version:
  2012-10-22 Vesa Oikonen
  2012-12-01 VO
  2012-12-04 VO
  2012-12-12 VO
  2012-12-20 VO
  2012-12-26 VO
  2013-01-28 VO
  2013-02-27 VO
  2013-03-10 VO
  2013-04-17 VO


******************************************************************************/
#ifndef _IDI_H
#define _IDI_H
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
/*****************************************************************************/
#include "libtpcmisc.h"
#include "curveio.h"
#include "libtpcmodel.h"
#include "imgio.h"
#include "imgproc.h"
#include "libtpcmodext.h"
/*****************************************************************************/
#include "libtpcidiv.h"
/*****************************************************************************/

/*****************************************************************************/
/* circle.c */
extern int imgCircleMask(
  IMG *img, int zi, double cx, double cy, double r, double mv, double *smv, 
  int verbose
);
extern int imgRingMask(
  IMG *img, int zi, double cx, double cy, double r1, double r2, double mv,
  double *smv, int verbose
);
/*****************************************************************************/

/*****************************************************************************/
/* heart.c */
extern int imgSimulateRing(
  IMG *img, int fi, int zi, double cx, double cy, 
  double r1, double r2, double vr, double vi, double vo,
  int verbose
);
extern int simMyocDiameterCurve(
  DFT *dft, double t1, double t2, double hbr, double maxdiam, double mindiam
);
int imgSimulateSphere(
  IMG *img, int fi, double cx, double cy, double cz, 
  double r1, double r2, double vr, double vi, double vo,
  int verbose
);
/*****************************************************************************/

/*****************************************************************************/
/* heartcor.c */
extern int heartcor(
  int verbose
);
extern int heartRecoverySpilloverCorrectionFactors(
  double R, double d, double s, double Vb,
  double *FMM, double *FMB, double *FBM, double *FBB
);
/*****************************************************************************/

/*****************************************************************************/
/* mask.c */
extern int imgMaskTAC(
  IMG *img, IMG *mask, double *tac, int verbose
);
extern int imgMaskPixelTACs(
  IMG *img, IMG *mask, double thrs, DFT *dft, int verbose
);
/*****************************************************************************/

/*****************************************************************************/
/* peak.c */
extern int imgGetConcWeightedPeakPos(
  IMG *img, float thrs, IMG_PIXEL *pos, int verbose
);
/*****************************************************************************/

/*****************************************************************************/
/* recovery.c */
extern double rcPeakPET(double FWHM, double R);
/*****************************************************************************/

/*****************************************************************************/
/* vessel.c */
extern int idiSimulateTubeVol(
  VOL *vol, int zi, double cx, double cy, double r, double FWHM,
  double cbkg, double cblo
);
extern int idiSimulateTubeImg(
  IMG *img, int zi, double cx, double cy, double r, double FWHM,
  double *cbkg, double *cblo
);
extern int idiSimulateTubeImgPlane(
  int simmet, IMG *img, int zi, double cx, double cy, double r, double FWHM,
  double *cbkg, double *cblo
);
/*****************************************************************************/
#endif /* _IDI_H */
