/*******************************************************************************
  Copyright (c) 2012,2013 by Turku PET Centre (TPC)

  File:         libtpcidiv.c  
  Purpose:      functions for printing the information on the library. 
  Version:      See the LIB_VERSION and history below.

*******************************************************************************/

/******************************************************************************/

/** Library name. */
#define LIB_NAME "libtpcidi"

/** Library version. */
#define LIB_VERSION "0.3.5"

/** Copyright. */
#define COPYRIGHT "(c) 2012,2013 by Turku PET Centre, University of Turku"

/******************************************************************************/
#include <stdio.h>
#include <float.h>
#include "include/libtpcidiv.h"
/******************************************************************************/

/******************************************************************************/
/** 
    Print the library History to specified FILE pointer, 
    use stdout for screen.
*/
void libtpcidi_print_history(FILE *fp)
{
  fputs(
  " \n"
  "2012-10-22 version 0.1.0 Vesa Oikonen\n"
  "  First created, based on previous code from separate TPC programs.\n"
  "2012-12-01 version 0.1.1 VO\n"
  "  Additional vessel simulation function.\n"
  "2012-12-04 version 0.1.2 VO\n"
  "  Additional vessel simulation function, and changes in previous ones.\n"
  "2012-12-12 version 0.2.0 VO\n"
  "  Added circle.c.\n"
  "2012-12-12 version 0.2.1 VO\n"
  "  Added mask.c.\n"
  "  Center position parameters are changed for functions\n"
  "  idiSimulateTubeVol(), idiSimulateTubeImg() and idiSimulateTubeImgPlane().\n"
  "2012-12-20 version 0.3.0 VO\n"
  "  Added peak.c and vessel.c.\n"
  "  Bug fix in idiSimulateTubeImg() and idiSimulateTubeImgPlane().\n"
  "2012-12-26 version 0.3.1 VO\n"
  "  Added a function in mask.c.\n"
  "2013-01-28 version 0.3.2 VO\n"
  "  Added heart.c.\n"
  "2013-02-27 version 0.3.3 VO\n"
  "  Additional parameter to heartRecoverySpilloverCorrectionFactors().\n"
  "2013-03-10 version 0.3.4 VO\n"
  "  Added a function in heart.c.\n"
  "2013-04-17 version 0.3.5 VO\n"
  "  Changes in includes.\n"
  "\n", fp);
  fflush(fp);
}
/******************************************************************************/
/** 
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpcidi_print_readme(FILE *fp)
{
  fputs(
  "\n"
  LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
  "\n"
  "Build "__DATE__" "__TIME__"\n"
  "\n"
  "\n"
  "Image-Derived Input (IDI) library\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "Library is distributed under the GNU Lesser General Public Licence\n"
  "http://www.turkupetcentre.net/software/lgpl-license.html\n"
  "More information on open source licences: http://www.opensource.org\n"
  "\n"
  "Description\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "The libtpcidi library contains several methods for processing PET image\n"
  "data, to retrieve input function for modelling at Turku PET Centre.\n"
  "\n"
  "List of files\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "Doxyfile        - Doxygen configuration file.\n"
  "include/        - Includes all the header files for the .c files\n"
  "Makefile        - The makefile\n"
  "\n"
  "** .c files **\n"
  "\n"
  "circle.c        - Simulating circular mask image.\n"
  "heart.c         - Simulating simple PET image of heart.\n"
  "heartcor.c      - Spill-over correction of heart data.\n"
  "mask.c          - Extracting TACs from image based on mask.\n"
  "peak.c          - Searching for peak in PET image.\n"
  "recovery.c      - Computing recovery coefficient in PET image.\n"
  "vessel.c        - Simulating PET image of vessel.\n"
  "libtpcidi.c     - Functions for running tests on libtpcidi.\n"
  "libtpcidiv.c    - Functions for printing information on this library.\n"
  "\n"
  "Using the library\n"
  "--------------------------------------------------------------------------\n"
  "\n"
  "The program that uses the library should include the .h file it needs.\n"
  "Example 1:\n"
  "    \\#include <idi.h>  // includes all library functions\n"
  "\n"
  "libtpcidi is dependent on other TPC libraries:\n"
  "    libtpcmisc, libtpcimgio, libtpcimgp, libtpccurveio,\n"
  "    libtpcmodel, libtpcmodext, libtpcsvg.\n"
  "\n"
  "Example:\n"
  "    gcc myprog.c -ltpcidi -ltpcmodext -ltpcmodel -ltpcimgp -ltpcimgio \n"
  "                 -ltpccurveio -ltpcsvg -lm\n"
  "\n", fp);

  fflush(fp);
}

/******************************************************************************/
/** 
    Print the library Readme to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcidi_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<pre>\n",
    LIB_NAME, LIB_VERSION, COPYRIGHT);
  libtpcidi_print_readme(fp);
  fprintf(fp,"\n</pre> \n */\n");
}

/******************************************************************************/
/** 
    Print the library History to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcidi_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<pre>\n");
  libtpcidi_print_history(fp);
  fprintf(fp,"\n</pre> \n */\n");
}

/******************************************************************************/
/** 
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpcidi_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n", LIB_NAME, LIB_VERSION, COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n", __DATE__, __TIME__);
#ifdef __STRICT_ANSI__
  fprintf(fp," (ANSI compatible build)\n");
#endif
#if defined(__FILE__) && defined(__TIMESTAMP__)
  printf(" File %s last edited on %s\n", __FILE__, __TIMESTAMP__);
#endif
#if defined(__STDC_VERSION__)
  printf(" Version of C: %ld\n", __STDC_VERSION__);
#endif
#if defined(__STDC_ISO_10646__)
  printf(" Compiler ISO/IEC 10646 specification: %ld\n", __STDC_ISO_10646__);
#endif
#if defined(__GNUC__) && defined(__VERSION__)
  printf(" GNU C version: %s\n", __VERSION__);
#endif
#ifdef _OPENMP
  printf(" OpenMP version: %d\n", _OPENMP);
#endif
#if defined(__x86_64__) || defined(__LP64__) || defined(__ppc64__)
  printf(" Architecture: 64-bit\n");
#else
  printf(" Architecture: 32-bit\n");
#endif
  printf(" Size of long double: %d bits\n", 8*(int)sizeof(long double));
#if defined(FLT_EVAL_METHOD)
  printf(" FLT_EVAL_METHOD: %d\n", FLT_EVAL_METHOD);
#endif
}
/******************************************************************************/

/******************************************************************************/
