/*****************************************************************************
  Copyright (c) 2006,2009,2012,2013 by Turku PET Centre

  imgfilter.h - Header for Gaussian filter.

  Modification history:
  2006-08-08 Kaisa Sederholm
      First created.
  2009-12-16 VO
      Added define for mallocMatrix().
  2009-12-29 VO
      Added functions imgFillGaussKernel(), imgConvolute2D(), and
      imgGaussianFilter().
  2012-12-20 VO
      Additional parameters for imgGaussianFilter().
  2013-03-08 VO
      Added functions imgFast2DGaussianFilter() and imgFast3DGaussianFilter().


******************************************************************************/

#ifndef _IMGFILTER_H
#define _IMGFILTER_H
/*****************************************************************************/
#include <img.h>
/*****************************************************************************/
extern int imgFillGaussKernel(
  float **kernel, float stdev, int size
);
extern int imgConvolute2D(
  float ***data, float **buffer, int frame, int width, int height,
  float **kernel, int size, int border, int verbose, char *errmsg
); 
extern int imgGaussianFilter(
  IMG *img, int plane, int frame, float gauss_sd, int size, int border,
  int verbose, char *errmsg 
);
extern int imgFast2DGaussianFilter(
  IMG *img, int plane, int frame, float gauss_sd, int step_nr,
  int verbose, char *errmsg 
);
extern int imgFast3DGaussianFilter(
  IMG *img, int frame, float gauss_sd, int step_nr, int verbose, char *errmsg);
/*****************************************************************************/
extern float **mallocMatrix(float w, float h);
extern float **imgGaussKernel(int size);
extern void imgFreeKernel(float **kernel, int size);
extern void imgConvoluteData(float ***data, float **buffer, int frame, 
  int width, int height, float **kernel, int size);
extern int imgConvolute(IMG *img, int frame, int plane, float **kernel, int size);
/*****************************************************************************/
#endif /* _IMGFILTER_H */
