/******************************************************************************
  Copyright (c) 2013 by Turku PET Centre

  File:      tacid.h

  Version:
  2013-09-02 Vesa Oikonen


******************************************************************************/
#ifndef _TACID_H
#define _TACID_H
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
/*****************************************************************************/
#include "libtpcmisc.h"
//#include "curveio.h"
/*****************************************************************************/

/*****************************************************************************/
/** Max length of TAC (Region) name (+1) */
#ifndef MAX_REGIONNAME_LEN
#define MAX_REGIONNAME_LEN 20
#endif
/** Max length of TAC Region name subfield (+1) */
#ifndef MAX_REGIONSUBNAME_LEN
#define MAX_REGIONSUBNAME_LEN 6
#endif
/** Max length of TAC ID names */
#ifndef MAX_TACID_LEN
#define MAX_TACID_LEN MAX_REGIONNAME_LEN
#endif
/** Max nr of sub name fields */
#ifndef MAX_SUBTACID_NR
#define MAX_SUBTACID_NR 3
#endif
/*****************************************************************************/
/** Definitions for parameter file format */
#define TACID_UNKNOWN    0
#define TACID_AVG        1
#define TACID_DX         2
#define TACID_SIN        3
#define TACID_REF        4
#define TACID_PLASMA     5
#define TACID_BLOOD      6
#define TACID_PARENT     7
#define TACID_METABOLITE 8
/*****************************************************************************/

/*****************************************************************************/
/**
 *  TAC ID structure definition
 */
typedef struct {
  /** Full name string, using '_' to separate subparts when necessary */
  char      name[MAX_REGIONNAME_LEN+1];
  /** TAC ID string subfields, contained in full name; traditionally,
   *  the send field is used to store hemisphere, and 3rd field the image plane;
      only for temporary use */
  char      sub[MAX_SUBTACID_NR][MAX_REGIONNAME_LEN+1];
  /** ROI side: TACID_UNKNOWN, TACID_AVG, TACID_DX, TACID_SIN */ 
  int       side;
  /** ROI image plane */ 
  int       plane;
  /** Input type: TACID_UNKNOWN, TACID_REF, TACID_PLASMA, TACID_BLOOD,
   *  TACID_PARENT, TACID_METABOLITE */
  int       input;  
  /** Temporary switches for outside procedures */
  char      sw, sw2, sw3;
} TACID;
/*****************************************************************************/

/*****************************************************************************/
/*****************************************************************************/

/*****************************************************************************/
#endif /* _TACID_H */
