/******************************************************************************

  libtpcrecv.c  (c) 2005 Turku PET Centre

  This file contains function for printing the date and time when this library
  is compiled.
  
  Version:
  2005-08-09 Jarkko Johansson

******************************************************************************/
#include <stdio.h>
#include "libtpcrecv.h"
/*****************************************************************************/
/** Library name. */
#define LIB_NAME "libtpcrec"

/** Library version. */
#define LIB_VERSION "beta"

/** Copyright. */
#define COPYRIGHT "(c) 2005 by Turku PET Centre"

/*****************************************************************************/
/** 
    Print the library readme to specified FILE pointer, use stdout for screen.
*/
void libtpcrec_print_readme(FILE *fp){
  fputs(
	"\n"
	LIB_NAME" "LIB_VERSION" "COPYRIGHT"\n"
	"\n"
	"Build "__DATE__" "__TIME__"\n"
	"\n"
	"\n"
	"PET Image Reconstruction Library\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"Turku PET Centre\n"
	"\n"
	"Libtpcrec is distributed under the GNU Lesser General Public Licence\n"
	"http://pet.utu.fi/staff/vesoik/programs/lgpl-license.html\n"
	"More information on open source licences: http://www.opensource.org\n"
	"\n"
	"Description\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"The libtpcrec library is a collection of commonly used C files in Turku PET Centre\n"
	"for image reconstruction. Libtpcrec library supports analyze,\n"
	"ecat 6.x, ecat 7.x and partly interfile formats. \n"
	"\n"
	"List of files\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"include/     - Includes all the header files for the .c files\n"
	"\n"
	"Makefile     - The makefile\n"
	"\n"
	"** .c files **\n"
	"\n"
	"ellipse.c   - Class modelling ellipse in 2D plane.\n"
	"\n"
	"prmat.c     - Functions for projection matrix creation and handeling.\n"
	"\n"
	"radon.c     - Class modelling Radon transform.\n"
	"\n"
	"libtpcrec.c - Program for printing Readme and History information, and for\n"
	"		 testing the library functions. \n"
	"\n"
	"libtpcrecv.c- Version information for this library.\n"
	"\n"
	"\n"
	"Using the library\n"
	"-------------------------------------------------------------------------------\n"
	"\n"
	"The program that uses the library should include the .h file it needs.\n"
	"Example:\n"
	"    #include <radon.h>\n"
	"\n"
	"Example:\n"
	"	gcc myprog.c -ltpcrec\n"
	"\n",
	fp
	);

  fflush(fp);
}

/** 
    Print the library History to specified FILE pointer, 
    use stdout for screen.
*/
void libtpcrec_print_history(FILE *fp)
{
  fputs(
	"\n2005-08-09 Jarkko Johansson\n"
	"\n2005-11-29 Jarkko Johansson\n"
	"\n",
	fp
	);
  fflush(fp);  
}

/** 
    Print the library Readme to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcrec_print_dreadme(FILE *fp)
{
  fprintf(fp,"/**\n\\mainpage %s %s %s\n\\section readme Readme\n<PRE>\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  libtpcrec_print_readme(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the library History to specified FILE pointer with Doxygen tags, 
    use stdout for screen.
*/
void libtpcrec_print_dhistory(FILE *fp)
{
  fprintf(fp,"/**\n\\page History\n\\section history History\n<PRE>\n");
  libtpcrec_print_history(fp);
  fprintf(fp,"\n</PRE> \n */\n");
}

/** 
    Print the build info to specified FILE pointer, use stdout for screen.
*/
void libtpcrec_print_build(FILE *fp)
{
  fprintf(fp,"\n %s %s %s\n",LIB_NAME,LIB_VERSION,COPYRIGHT);
  fprintf(fp,"\n Build %s %s\n",__DATE__,__TIME__);
}



/** Print the compilation date and time to specified FILE pointer  */
void libtpcrec_printdate(FILE *fp)
{
  libtpcrec_print_build(fp);
}

/*****************************************************************************/

/*****************************************************************************/

